% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BubleyDyerSeparation.R
\name{BubleyDyerSeparation}
\alias{BubleyDyerSeparation}
\title{Approximated separation matrices computation, using the Bubley-Dyer procedure (see Bubley and Dyer, 1999).}
\usage{
BubleyDyerSeparation(
  generator,
  n = NULL,
  error = NULL,
  output_every_sec = NULL
)
}
\arguments{
\item{generator}{The approximated separation matrices generator created by function \code{\link[=BuildBubleyDyerSeparationGenerator]{BuildBubleyDyerSeparationGenerator()}}.}

\item{n}{number of linear extensions generated to compute the approximated MRP matrix.
See documentation for function \code{\link[=BubleyDyerMRP]{BubleyDyerMRP()}} for further information on this argument.}

\item{error}{A real number in \eqn{(0,1)} representing the "distance" from uniformity of the
sampling distribution of the linear extensions.
This parameter is used to determine the number of linear extensions to be sampled.
If both arguments \code{n} and \code{error} are specified by the user, the number of linear extensions actually generated
is \code{n}.
See documentation for function \code{BubleyDyerMRP} for further information on this argument.}

\item{output_every_sec}{Integer specifying a time interval (in seconds).
By specifying this argument, during the execution of \code{BubleyDyerSeparation}, a message reporting the number of linear extensions
progressively generated is printed on the R-Console, every \code{output_every_sec} seconds.}
}
\value{
A list containing: 1) the required type of approximated separation matrices, according to the parameter \code{type} used
to build the \code{generator} ( see\code{\link[=BuildBubleyDyerSeparationGenerator]{BuildBubleyDyerSeparationGenerator()}}); 2) the number of generated linear extensions.
}
\description{
Computes approximated separation matrices, starting from a set of linear extensions
sampled according to the Bubley-Dyer procedure.
}
\details{
See the documentation of \code{\link[=BuildBubleyDyerSeparationGenerator]{BuildBubleyDyerSeparationGenerator()}} for details on how the different types of separations
are defined and computed.
}
\examples{
el <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = el, dom = dom)

BDgen <- BuildBubleyDyerSeparationGenerator(pos, seed = NULL,
                  type="symmetric", "asymmetricUpper", "vertical")

SEP_matrices <- BubleyDyerSeparation(BDgen, n=10000, output_every_sec=5)

}
\references{
Bubley, R., Dyer, M. (1999). Faster random generation of linear extensions.
Discrete Mathematics, 201, 81-88. https://doi.org/10.1016/S0012-365X(98)00333-1
}
