% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorers.R
\name{hScores}
\alias{hScores}
\title{Entropy scores}
\usage{
hScores(X, threads = 0)
}
\arguments{
\item{X}{Attribute table, given as a data frame with either factors (preferred), booleans, integers (treated as categorical) or reals (which undergo automatic categorisation; see below for details).
Single vector will be interpreted as a data.frame with one column.
\code{NA}s are not allowed.}

\item{threads}{Number of threads to use; default value, 0, means all available to OpenMP.}
}
\value{
A numerical vector with entropy scores, with names copied from \code{X}.
}
\description{
Calculates entropy of each feature, that is
\deqn{H(X).}
}
\note{
The method requires input to be discrete to use empirical estimators of distribution, and, consequently, information gain or entropy.
To allow smoother user experience, praznik automatically coerces non-factor vectors in inputs, which requires additional time, memory and may yield confusing results -- the best practice is to convert data to factors prior to feeding them in this function.
Real attributes are cut into about 10 equally-spaced bins, following the heuristic often used in literature.
Precise number of cuts depends on the number of objects; namely, it is \eqn{n/3}, but never less than 2 and never more than 10.
Integers (which technically are also numeric) are treated as categorical variables (for compatibility with similar software), so in a very different way -- one should be aware that an actually numeric attribute which happens to be an integer could be coerced into a \eqn{n}-level categorical, which would have a perfect mutual information score and would likely become a very disruptive false positive.
}
\examples{
hScores(iris[,-5])
}
