% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcens_quantile.R
\name{pcens_quantile.default}
\alias{pcens_quantile.default}
\title{Default method for computing primary event censored quantiles}
\usage{
\method{pcens_quantile}{default}(
  object,
  p,
  pwindow,
  D = Inf,
  use_numeric = FALSE,
  init = 5,
  tol = 1e-08,
  max_iter = 10000,
  ...
)
}
\arguments{
\item{object}{A \code{primarycensored} object as created by \code{\link[=new_pcens]{new_pcens()}}.}

\item{p}{A vector of probabilities at which to compute the quantiles.}

\item{pwindow}{Primary event window}

\item{D}{Maximum delay (truncation point). If finite, the distribution is
truncated at D. If set to Inf, no truncation is applied. Defaults to Inf.}

\item{use_numeric}{Logical; if TRUE forces the use of numeric inversion even
if an analytical solution is available (not yet implemented).}

\item{init}{Initial guess for the delay. By default, 5.}

\item{tol}{Numeric tolerance for the convergence criterion in the
optimisation routine.}

\item{max_iter}{Integer specifying the maximum number of iterations allowed
during optimisation.}

\item{...}{Additional arguments passed to underlying functions.}
}
\value{
A numeric vector containing the computed primary event censored
quantiles.
}
\description{
This method inverts the primary event censored CDF using numerical
optimisation via optim. For each probability value, it searches for the
delay such that the CDF computed by \code{\link[=pcens_cdf]{pcens_cdf()}} approximates the target
probability.
}
\details{
The quantile is computed by minimising the squared difference between the
computed CDF and the target probability.
}
\examples{
# Create a primarycensored object with gamma delay and uniform primary
pcens_obj <- new_pcens(
  pdist = pgamma,
  dprimary = dunif,
  dprimary_args = list(min = 0, max = 1),
  shape = 3,
  scale = 2
)

# Compute quantile for a single probability
pcens_quantile(pcens_obj, p = 0.8, pwindow = 1)

# Compute quantiles for multiple probabilities
pcens_quantile(pcens_obj, p = c(0.25, 0.5, 0.75), pwindow = 1)

# Compute quantiles for multiple probabilities with truncation
pcens_quantile(pcens_obj, p = c(0.25, 0.5, 0.75), pwindow = 1, D = 10)
}
\seealso{
Low level primary event censored distribution objects and methods
\code{\link{new_pcens}()},
\code{\link{pcens_cdf}()},
\code{\link{pcens_cdf.default}()},
\code{\link{pcens_cdf.pcens_pgamma_dunif}()},
\code{\link{pcens_cdf.pcens_plnorm_dunif}()},
\code{\link{pcens_cdf.pcens_pweibull_dunif}()},
\code{\link{pcens_quantile}()}
}
\concept{pcens}
