% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotted_chart.R
\name{dotted_chart}
\alias{dotted_chart}
\alias{dotted_chart.eventlog}
\alias{dotted_chart.activitylog}
\alias{dotted_chart.grouped_eventlog}
\alias{dotted_chart.grouped_activitylog}
\title{Dotted Chart}
\usage{
dotted_chart(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = c("auto", "start", "end", "duration", "start_week", "start_day"),
  color = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  add_end_events = FALSE,
  scale_color = bupaR::scale_color_discrete_bupaR,
  plotly = FALSE,
  eventlog = deprecated()
)

\method{dotted_chart}{eventlog}(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = c("auto", "start", "end", "duration", "start_week", "start_day"),
  color = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  add_end_events = FALSE,
  scale_color = bupaR::scale_color_discrete_bupaR,
  plotly = FALSE,
  eventlog = deprecated()
)

\method{dotted_chart}{activitylog}(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = c("auto", "start", "end", "duration", "start_week", "start_day"),
  color = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  add_end_events = FALSE,
  scale_color = bupaR::scale_color_discrete_bupaR,
  plotly = FALSE,
  eventlog = deprecated()
)

\method{dotted_chart}{grouped_eventlog}(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = c("auto", "start", "end", "duration", "start_week", "start_day"),
  color = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  add_end_events = FALSE,
  scale_color = bupaR::scale_color_discrete_bupaR,
  plotly = FALSE,
  eventlog = deprecated()
)

\method{dotted_chart}{grouped_activitylog}(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = c("auto", "start", "end", "duration", "start_week", "start_day"),
  color = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  add_end_events = FALSE,
  scale_color = bupaR::scale_color_discrete_bupaR,
  plotly = FALSE,
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR:log]{log}}: Object of class \code{\link[bupaR:log]{log}} or derivatives (\code{\link[bupaR:grouped_log]{grouped_log}},
\code{\link[bupaR:eventlog]{eventlog}}, \code{\link[bupaR:activitylog]{activitylog}}, etc.).}

\item{x}{\code{\link{character}} (default \code{"absolute"}): Value to plot on x-axis: \code{"absolute"} time or \code{"relative"} time
(since start of week: \code{"relative_week"}, since start of day: \code{"relative_day"}).}

\item{sort}{\code{\link{character}} (default \code{"auto"}): Ordering of the cases on y-axis: \code{"auto"} (default, see \strong{Details}),
\code{"start"}, \code{"end"}, \code{"duration"}, \code{"start_week"}, or \code{"start_day"}.}

\item{color}{\code{\link{character}} (default \code{\link{NULL}}): Attribute to use for coloring the activity instances (dots).
This attribute should be present in \code{log}. Default (\code{\link{NULL}}) is the activity identifier (\code{\link[bupaR:activity_id]{activity_id()}}).
Use \code{\link{NA}} for no colors.}

\item{units}{\code{\link{character}} (default \code{"auto"}): Time units to use on the x-axis in case of relative time: \code{"auto"}
(default, see \strong{Details}), \code{"secs"}, \code{"mins"}, \code{"hours"}, \code{"days"}, or \code{"weeks"}.}

\item{add_end_events}{\code{\link{logical}} (default \code{FALSE}): Whether to add dots for the complete lifecycle event with a different shape.}

\item{scale_color}{\code{ggplot2} scale function (default \code{\link[bupaR:scale_fill_discrete_bupaR]{scale_color_discrete_bupaR}}):
Set color scale. Defaults to \code{\link[bupaR:scale_fill_discrete_bupaR]{scale_color_discrete_bupaR}}.  Replaced with \code{\link[ggplot2:scale_colour_discrete]{scale_color_discrete}} when more than 26 activities are present.}

\item{plotly}{\code{\link{logical}} (default \code{FALSE}): Return a \code{plotly} object, instead of a \code{ggplot2}.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\description{
A dotted chart is a graph in which each activity instance is displayed with a point (dot). The x-axis refers to the
time aspect, while the y-axis refers to cases.
}
\details{
When setting \code{sort} to \code{"auto"}, the ordering of cases is done automatically, based on the specified value of \code{x}:
\itemize{
\item \code{x = "absolute"}: \code{sort = "start"},
\item \code{x = "relative"}: \code{sort = "duration"},
\item \code{x = "relative_week"}: \code{sort = "start_week"},
\item \code{x = "relative_day"}: \code{sort = "start_day"}.
}

When setting \code{units} to \code{"auto"}, the time units on the x-axis is done automatically, based on the specified value of \code{x}:
\itemize{
\item \code{x = "absolute"}: \code{units = "weeks"},
\item \code{x = "relative"}: \code{units = "weeks"},
\item \code{x = "relative_week"}: \code{units = "secs"},
\item \code{x = "relative_day"}: \code{units = "secs"}.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{dotted_chart(eventlog)}: Create dotted chart for an \code{\link[bupaR:eventlog]{eventlog}}.

\item \code{dotted_chart(activitylog)}: Create dotted chart for an \code{\link[bupaR:activitylog]{activitylog}}.

\item \code{dotted_chart(grouped_eventlog)}: Create dotted chart for a \code{\link[bupaR:grouped_eventlog]{grouped_eventlog}}.

\item \code{dotted_chart(grouped_activitylog)}: Create dotted chart for a \code{\link[bupaR:grouped_activitylog]{grouped_activitylog}}.

}}
\examples{
library(processmapR)
library(eventdataR)

patients \%>\%
 dotted_chart(x = "absolute", sort = "start", color = "employee")

}
