% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prof-tree.R
\name{prof.tree}
\alias{print.ProfTree}
\alias{prof.tree}
\title{Summarise Output of R Sampling Profiler}
\usage{
prof.tree(filename = "Rprof.out")

\method{print}{ProfTree}(x, limit = 10, ...)
}
\arguments{
\item{filename}{Name of a file produced by Rprof().}

\item{x}{A \code{ProfTree} object.}

\item{limit}{The maximum number of nodes to print. Can be \code{NULL} if the entire tree should be printed.}

\item{...}{not used.}
}
\description{
Summarise the output of the Rprof function to show the amount of time used by different R functions.
}
\examples{
Rprof(tmp <- tempfile())
example(glm)
Rprof(NULL)
tree <- prof.tree(tmp)
print(tree, limit = 20)
unlink(tmp)

}

