% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{STARplus}
\alias{STARplus}
\title{STAR participants plus nonexperimental controls}
\format{
A \code{data.frame} with 13,382 rows and 56 columns.
\itemize{
\item {stdnid} Student ID
\item {gender} Student gender
\item {race} Student race
\item {birthmonth} Student month of birth
\item {birthday} Student day of birth
\item {birthyear} Student year of birth
\item {read_yr1} SAT reading scaled score from grade at which
student entered the study
\item {math_yr1} SAT math scaled score from grade at which
student entered the study
\item {gktreadss} Kindergarten reading scaled score (RCT participants only)
\item {gktmathss} Kindergarten math scaled score (RCT participants only)
\item {gktlistss} Kindergarten listening scaled score (RCT participants only)
\item {gkwordskillss} Kindergarten word study skills scaled score (RCT participants only)
\item {g1schid} Grade 1 School ID
\item {g1tchid} Grade 1 Teacher ID
\item {g1classsize} Class size of Grade 1
\item {g1treadss} Grade 1 SAT reading scaled score
\item {g1tmathss} Grade 1 SAT math scaled score
\item {g1tlistss} Grade 1 total listening scale score in SAT
\item {g1wordskillss} Grade 1 word study skills scale score in SAT
\item {g1readbsraw} Grade 1 reading raw score in Basic Skills First (BSF) tests
\item {g1mathbsraw} Grade 1 math raw score in BSF
\item {g1readbsobjpct} Grade 1 reading percent objectives mastered in BSF tests
\item {g1mathbsobjpct} Grade 1 math percent objectives mastered in BSF tests
\item {g2schid} Grade 2 School ID
\item {g2tchid} Grade 2 Teacher ID
\item {g2classsize} Class size of Grade 2
\item {g2treadss} Grade 2 total reading scale score in SAT
\item {g2tmathss} Grade 2 total math scale score in SAT
\item {g2tlistss} Grade 2 total listening scale score in SAT
\item {g2wordskillss} Grade 2 word study skills scale score in SAT
\item {g2readbsraw} Grade 2 reading raw score in BSF tests
\item {g2mathbsraw} Grade 2 math raw score in BSF test
\item {g2readbsobjpct} Grade 2 reading percent objectives mastered in BSF tests
\item {g3schid} Grade 3 School ID
\item {g3tchid} Grade 3 Teacher ID
\item {g3classsize} Class size of Grade 3
\item {g3treadss} Grade 3 total reading scale score in SAT
\item {g3tmathss} Grade 3 total math scale score in SAT
\item {g3langss} Grade 3 total language scale score in SAT
\item {g3tlistss} Grade 3 total listening scale score in SAT
\item {g3socialsciss} Grade 3 social science scale score in SAT
\item {g3spellss} Grade 3 spelling scale score in SAT
\item {g3vocabss} Grade 3 vocabulary scale score in SAT
\item {g3mathcomputss} Grade 3 math computation scale score in SAT
\item {g3mathnumconcss} Grade 3 concept of numbers scale score in SAT
\item {g3mathapplss} Grade 3 math applications scale score in SAT
\item {g3wordskillss} Grade 3 word study skills scale score in SAT
\item {g3readbsraw} Grade 3 reading raw score in BSF tests
\item {g3mathbsraw} Grade 3 math raw score in BSF tests
\item {g3readbsobjpct} Grade 3 reading percent objectives mastered in BSF tests
\item {g3mathbsobjpct} Grade 3 math percent objectives mastered in BSF tests
\item {dob} Date of birth (with NAs imputed RCT participant median)
\item {dobNA} Dat of birth not recorded
\item {grade_at_entry} Grade at which each student first entered the study
\item {school_at_entry} School ID corresponding to the student's grade
at entry into the study
\item {cond_at_entry} Classroom type corresponding to the student's grade
at entry into the study
}
}
\source{
\doi{doi:10.7910/DVN/SIWH9F}
}
\usage{
STARplus
}
\description{
Data from Tennessee’s Project STAR study.
This data frame describes student participants in the Project
STAR (Student-Teacher Achievement Ratio) field experiment
conducted in Tennessee, USA beginning in the mid-1980s, as well
as an external control group consisting of the contemporaneous
cohort of students attending a matched sample of Tennessee
schools that did not participate in the STAR experiment.
Variables are as described in Project \code{STAR} data
documentation (see references), with five exceptions.
Three \code{*_at_entry} variables were constructed
as follows: \code{grade_at_entry} indicates the grade of student's
first participation, while \code{school_at_entry} and
\code{cond_at_entry} reflect the school ID and classroom type corresponding
to the student's grade at entry to the study. Additionally, \code{read_yr1}
and \code{math_yr1} capture a student's scaled scores on the Scholastic
Assessment Test (SAT) administered to them during their \code{grade_of_entry},
i.e. their earliest available post-treatment SAT measurements.
}
\details{
Note: This dataset bears a Creative Commons Zero license (v1.0).
}
\references{
C.M. Achilles; Helen Pate Bain; Fred Bellott; Jayne Boyd-Zaharias;
Jeremy Finn; John Folger; John Johnston; Elizabeth Word, 2008,
"Tennessee's Student Teacher Achievement Ratio (STAR) project",
Harvard Dataverse, V1, https://doi.org/10.7910/DVN/SIWH9F UNF:3:Ji2Q+9HCCZAbw3csOdMNdA
}
\keyword{dataset}
