% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_level_disprop_analysis.R
\name{add_disproportionality}
\alias{add_disproportionality}
\title{Add disproportionality estimates to data frame
with expected counts}
\usage{
add_disproportionality(
  df = NULL,
  df_syms = NULL,
  da_estimators = c("ic", "prr", "ror"),
  rule_of_N = 3,
  conf_lvl = 0.95
)
}
\arguments{
\item{df}{Intended use is on the output tibble from \code{add_expected_counts}.}

\item{df_syms}{A list built from df_colnames through conversion to symbols.}

\item{da_estimators}{Character vector specifying which disproportionality
estimators to use, in case you don't need all implemented options. Defaults
to c("ic", "prr", "ror").}

\item{rule_of_N}{Numeric value. Sets estimates for ROR and PRR to NA when observed
counts are strictly less than the passed value of \code{rule_of_N}. Default value
is 3, 5 is sometimes used as a more liberal alternative. Set to NULL if you
don't want to apply any such rule.}

\item{conf_lvl}{Confidence level of confidence or credibility intervals.
Default is 0.95 (i.e. 95 \% confidence interval).}
}
\value{
The passed data frame with disproportionality point and interval
estimates.
}
\description{
Add disproportionality estimates to data frame
with expected counts
}
