% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetQualifications.R
\name{GetQualifications}
\alias{GetQualifications}
\alias{ListWorkersWithQualificationType}
\alias{getquals}
\title{Get Qualifications}
\usage{
GetQualifications(qual, status = NULL, results = as.integer(100),
  pagetoken = NULL, verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{qual}{A character string containing a QualificationTypeId for a custom
(i.e., not built-in) QualificationType.}

\item{status}{An optional character string specifying whether only
\dQuote{Granted} or \dQuote{Revoked} Qualifications should be returned.}

\item{results}{An optional character string indicating how many results to
fetch per page. Must be between 1 and 100. Most users can ignore this.}

\item{pagetoken}{An optional character string indicating which page of
search results to start at. Most users can ignore this.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the QualificationTypeId, WorkerId, and
Qualification scores of workers assigned the Qualification.
}
\description{
Get all Qualifications of a particular QualificationType assigned to
Workers.
}
\details{
A function to retrieve Qualifications granted for the specified
QualificationType. To retrieve a specific Qualification score (e.g., for one
worker), use \code{\link{GetQualificationScore}}.

A practical use for this is with automatically granted QualificationTypes.
After workers request and receive an automatically granted Qualification
that is tied to one or more HITs, \code{GetQualifications} can be used to
retrieve the WorkerIds for workers that are actively working on those HITs
(even before they have submitted an assignment).

\code{getquals()} and \code{ListWorkersWithQualificationType()} are aliases.
}
\examples{

\dontrun{
qual1 <- AssignQualification(workers = "A1RO9UJNWXMU65",
                    name = "Worked for me before",
                    description = "This qualification is for people who have worked for me before",
                    status = "Active",
                    keywords = "Worked for me before")

GetQualifications(qual1$QualificationTypeId)
RevokeQualification(qual1$QualificationTypeId, qual1$WorkerId)
GetQualifications(qual1$QualificationTypeId, status="Revoked")

DisposeQualificationType(qual1$QualificationTypeId)
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html}{API Reference}
}
\seealso{
\code{\link{GetQualificationScore}}

\code{\link{UpdateQualificationScore}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Qualifications}
