% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus-methods-quanteda.R
\name{docvars}
\alias{docvars}
\alias{docvars<-}
\title{get or set for document-level variables}
\usage{
docvars(x, field = NULL)

docvars(x, field = NULL) <- value
}
\arguments{
\item{x}{corpus whose document-level variables will be read or set}

\item{field}{string containing the document-level variable name}

\item{value}{the new values of the document-level variable}
}
\value{
\code{docvars} returns a data.frame of the document-level variables

\code{docvars<-} assigns \code{value} to the named \code{field}
}
\description{
Get or set variables for the documents in a corpus
}
\note{
Another way to access and set docvars is through indexing of the corpus \code{j} element, 
such as \code{data_corpus_irishbudget2010[, c("foren", "name"]} or for a single docvar, \code{data_corpus_irishbudget2010[["name"]]}.  The latter
also permits assignment, including the easy creation of new document varibles, e.g. \code{data_corpus_irishbudget2010[["newvar"]] <- 1:ndoc(data_corpus_irishbudget2010)}.
See \code{\link{[.corpus}} for details.
}
\examples{
head(docvars(data_corpus_inaugural))
docvars(data_corpus_inaugural, "President") <- paste("prez", 1:ndoc(data_corpus_inaugural), sep="")
head(docvars(data_corpus_inaugural))

# alternative using indexing
head(data_corpus_inaugural[, "Year"])
data_corpus_inaugural[["President2"]] <- paste("prezTwo", 1:ndoc(data_corpus_inaugural), sep="")
head(docvars(data_corpus_inaugural))
}
\keyword{corpus}

