/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Process;

import com.conveyal.r5.OneOriginResult;
import com.conveyal.r5.analyst.cluster.AnalysisWorkerTask;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.transit.TransportNetwork;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.Process.R5Process;
import org.ipea.r5r.R5.R5TravelTimeComputer;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;

public class ParetoFrontierCalculator
extends R5Process {
    @Override
    protected boolean isOneToOne() {
        return false;
    }

    public ParetoFrontierCalculator(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        super(threadPool, transportNetwork, routingProperties);
    }

    @Override
    protected RDataFrame runProcess(int index) throws ParseException {
        RegionalTask request = this.buildRequest(index);
        R5TravelTimeComputer computer = new R5TravelTimeComputer((AnalysisWorkerTask)request, this.transportNetwork);
        HashMap<Float, OneOriginResult> travelTimeResults = new HashMap<Float, OneOriginResult>();
        for (float fareCutoff : this.routingProperties.fareCutoffs) {
            request.maxFare = fareCutoff >= 0.0f ? Math.round(fareCutoff * 100.0f) : Integer.MAX_VALUE;
            OneOriginResult results = computer.computeTravelTimes();
            travelTimeResults.put(Float.valueOf(fareCutoff), results);
        }
        RDataFrame travelTimesTable = this.buildDataFrameStructure(this.fromIds[index], 10);
        this.populateDataFrame(travelTimeResults, travelTimesTable);
        if (travelTimesTable.nRow() > 0) {
            return travelTimesTable;
        }
        return null;
    }

    @Override
    protected RDataFrame buildDataFrameStructure(String fromId, int nRows) {
        RDataFrame travelTimesTable = new RDataFrame(nRows);
        travelTimesTable.addStringColumn("from_id", fromId);
        travelTimesTable.addStringColumn("to_id", "");
        travelTimesTable.addIntegerColumn("percentile", 0);
        travelTimesTable.addIntegerColumn("travel_time", 0);
        travelTimesTable.addDoubleColumn("monetary_cost", 0.0);
        return travelTimesTable;
    }

    private void populateDataFrame(Map<Float, OneOriginResult> travelTimeResults, RDataFrame travelTimesTable) {
        for (int destination = 0; destination < this.nDestinations; ++destination) {
            for (int percentileIndex = 0; percentileIndex < this.routingProperties.percentiles.length; ++percentileIndex) {
                boolean first = true;
                int previousTT = -1;
                for (float fare : this.routingProperties.fareCutoffs) {
                    OneOriginResult travelTimesByFare = travelTimeResults.get(Float.valueOf(fare));
                    int tt = travelTimesByFare.travelTimes.getValues()[percentileIndex][destination];
                    if (!(tt != previousTT & tt < this.maxTripDuration)) continue;
                    if (first) {
                        travelTimesTable.append();
                        travelTimesTable.set("to_id", this.toIds[destination]);
                        travelTimesTable.set("percentile", this.routingProperties.percentiles[percentileIndex]);
                    } else {
                        travelTimesTable.appendRepeat();
                    }
                    travelTimesTable.set("monetary_cost", Double.valueOf(fare));
                    travelTimesTable.set("travel_time", tt);
                    previousTT = tt;
                    first = false;
                }
            }
        }
    }

    @Override
    protected RegionalTask buildRequest(int index) throws ParseException {
        RegionalTask request = super.buildRequest(index);
        request.destinationPointSetKeys = this.opportunities;
        request.destinationPointSets = this.destinationPoints;
        return request;
    }
}

