% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.functions.R
\name{folded.matern.covariance.1d}
\alias{folded.matern.covariance.1d}
\title{The 1d folded Matern covariance function}
\usage{
folded.matern.covariance.1d(
  h,
  m,
  kappa,
  nu,
  sigma,
  L = 1,
  N = 10,
  boundary = c("neumann", "dirichlet", "periodic")
)
}
\arguments{
\item{h, m}{Vectors of arguments of the covariance function.}

\item{kappa}{Range parameter.}

\item{nu}{Shape parameter.}

\item{sigma}{Standard deviation.}

\item{L}{The upper bound of the interval \eqn{[0,L]}. By default, \code{L=1}.}

\item{N}{The truncation parameter.}

\item{boundary}{The boundary condition. The possible conditions
are \code{"neumann"} (default), \code{"dirichlet"} or
\code{"periodic"}.}
}
\value{
A matrix with the corresponding covariance values.
}
\description{
\code{folded.matern.covariance.1d} evaluates the 1d
folded Matern covariance function over an interval \eqn{[0,L]}.
}
\details{
\code{folded.matern.covariance.1d} evaluates the 1d folded Matern
covariance function over an interval \eqn{[0,L]} under different
boundary conditions. For periodic boundary conditions
\deqn{C_{\mathcal{P}}(h,m) = \sum_{k=-\infty}^{\infty} (C(h-m+2kL),}
for Neumann boundary conditions
\deqn{C_{\mathcal{N}}(h,m) = \sum_{k=-\infty}^{\infty}
(C(h-m+2kL)+C(h+m+2kL)),}
and for Dirichlet boundary conditions:
\deqn{C_{\mathcal{D}}(h,m) = \sum_{k=-\infty}^{\infty}
(C(h-m+2kL)-C(h+m+2kL)),}
where \eqn{C(\cdot)} is the Matern covariance function:
\deqn{C(h) = \frac{\sigma^2}{2^{\nu-1}\Gamma(\nu)}(\kappa h)^\nu
K_\nu(\kappa h).}

We consider the truncation:
\deqn{C_{{\mathcal{P}},N}(h,m) = \sum_{k=-N}^{N} C(h-m+2kL),
C_{\mathcal{N},N}(h,m) = \sum_{k=-\infty}^{\infty}
(C(h-m+2kL)+C(h+m+2kL)),}
and
\deqn{C_{\mathcal{D},N}(h,m) = \sum_{k=-N}^{N}
(C(h-m+2kL)-C(h+m+2kL)).}
}
\examples{
x <- seq(from = 0, to = 1, length.out = 101)
plot(x, folded.matern.covariance.1d(rep(0.5, length(x)), x,
  kappa = 10, nu = 1 / 5, sigma = 1
),
type = "l", ylab = "C(h)", xlab = "h"
)

}
