% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones_to_raster.R
\name{zones_to_raster}
\alias{zones_to_raster}
\title{Convert zones to rasters}
\usage{
zones_to_raster(v, resolution, variables, ...)
}
\arguments{
\item{v}{An sf object (POLYGON or MULTIPOLYGON)}

\item{resolution}{A numeric vector of length 1 or 2 to set the resolution}

\item{variables}{A character vector with columns names from \code{v}.
The values from these columns will be (1) rasterized and (2) recalculated to densities.
Each column will be represented as an layer in the output RasterStack}

\item{...}{Additional arguments as for \code{\link[terra:rasterize]{terra::rasterize()}}}
}
\value{
a SpatRaster
}
\description{
Convert zones to rasters
}
\examples{
library(sf)
library(terra)
plot(pop_vector)
popdens_raster = zones_to_raster(pop_vector, resolution = 30,
                                 variables = c("ASIAN", "BLACK", "HISPANIC", "OTHER", "WHITE"))
plot(popdens_raster)
}
