% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpaRaoAreaS.R
\name{mpaRaoAreaS}
\alias{mpaRaoAreaS}
\title{Area-Based Sequential Parametric Rao's index of quadratic entropy (Q)}
\usage{
mpaRaoAreaS(rasterm, area, alpha, simplify, dist_m, rescale, lambda, window)
}
\arguments{
\item{rasterm}{Raster; the input raster data representing variables across a geographic space.}

\item{area}{Numeric; the input vector data representing the areas of interest.}

\item{alpha}{Numeric; alpha value for order of diversity in Hill's Index.}

\item{simplify}{Numeric; the parameter that determines the rounding off of the calculations.}

\item{dist_m}{Character; type of distance metric used (e.g., "euclidean", "manhattan", etc.).}

\item{rescale}{Logical; whether to scale and centre the values in each element of the raster data.}

\item{lambda}{Numeric; lambda parameter for Minkowski distance calculation.}

\item{window}{Numeric; defines the size of the moving window for the analysis.}
}
\value{
A vector similar to the input, with additional columns representing Rao's index values for 
each area.
}
\description{
Calculates an area-based sequential version of the parametric Rao's index of quadratic entropy (Q). 
This function is designed for situations where the diversity index needs to consider geographical 
areas and works with raster data representing the distribution of species or other measures.
}
\seealso{
\code{\link{paRao}} for a related function dealing with the parallel computation of Rao's index.
}
\author{
Matteo Marcantonio \email{marcantoniomatteo@gmail.com},
Duccio Rocchini \email{duccio.rocchini@unibo.it},
Michele Torresani \email{michele.torresani@unibo.it}
}
