% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_anoles.R
\docType{data}
\name{anoles}
\alias{anoles}
\title{Data and phylogenetic tree for Anolis lizards}
\format{A list with a dataframe with the morphological data ($data) and a list of stochastic mapped trees with three regimes "island", "mainland" and "mainland.2" ($phy.map).}
\usage{
data(anoles)
}
\description{
See description of the data in Caetano and Harmon (2018). Measurements are log-transformed. Morphological data was compiled from Pinto et al. (2008), Mahler (2010), and Moreno-Arias and Calderon-Espinosa (2016). "Limb_length" data is a composite measurement calculated from the sum of the parts of the front limb.
}
\references{
Moreno-Arias, R. A., and M. L. Calderon-Espinosa. 2016. Patterns of morphological diversification of mainland Anolis lizards from northwestern South America. Zool J Linn Soc 176:632–647.

Pinto, G., D. L. Mahler, L. J. Harmon, and J. B. Losos. 2008. Testing the island effect in adaptive radiation: rates and patterns of morphological diversification in Caribbean and mainland Anolis lizards. Proc Biol Sci 275:2749–2757.

Mahler, D. L., L. J. Revell, R. E. Glor, and J. B. Losos. 2010. Ecological Opportunity and the Rate of Morphological Evolution in the Diversification of Greater Antillean Anoles. Evolution 64:2731–2745.
}
\keyword{datasets}
