% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{canonize}
\alias{canonize}
\title{Construct the canonical design matrix \eqn{A = [C | S; M | Q]} for CLSP.}
\usage{
canonize(
  object,
  problem = "",
  C = NULL,
  S = NULL,
  M = NULL,
  Q = NULL,
  b = NULL,
  m = NULL,
  p = NULL,
  i = 1L,
  j = 1L,
  zero_diagonal = FALSE
)
}
\arguments{
\item{object}{An object of class \code{"clsp"}.}

\item{problem}{Character, optional. Structural template for matrix
construction. One of:
\itemize{
\item \code{'ap'}   or \code{'tm'}: allocation or tabular matrix problem.
\item \code{'cmls'} or \code{'rp'}: constrained modular least squares or RP-type.
\item \code{''}     or other: General CLSP problems (user-defined C and/or M).
}}

\item{C, S, M}{Numeric matrix or \code{NULL}. Blocks of the constraint
matrix \eqn{A = [C | S; M | Q]}. If \code{C} and/or \code{M} are
provided, the matrix A is constructed accordingly. If both are
\code{NULL} and A is not yet defined, an error is raised.}

\item{Q}{Numeric matrix or \code{NULL}. Externally supplied residual slack
matrix used to adjust inequality constraints in M. Required only when
\eqn{r > 1}. Encodes the sign pattern of residuals from the previous
iteration and is used to construct the \eqn{[C | S; M | Q]} canonical
form. Defaults to a conformable zero matrix on the first iteration.}

\item{b}{Numeric vector or \code{NULL}. Right-hand side vector. Must have
as many rows as \eqn{A}. Required.}

\item{m, p}{Integer or \code{NULL}. Dimensions of
\eqn{X \in \mathbb{R}^{m \times p}}, relevant for allocation problems
('ap').}

\item{i, j}{Integer, default = \code{1}. Grouping sizes for row and column
sum constraints in AP problems.}

\item{zero_diagonal}{Logical, default = \code{FALSE}. If \code{TRUE},
enforces structural zero diagonals via identity truncation.}
}
\value{
An updated object of class \code{"clsp"}.
}
\description{
This method assembles the constraint matrix A from user-supplied or
internally generated components — C, S, M, and Q — and assigns the
corresponding right-hand side vector b. It is a required pre-step before
solving a Convex Least Squares Programming (CLSP) problem.
}
\details{
Depending on the specified problem type, it can generate allocation,
tabular matrix, or modular constraints and enforce optional diagonal
exclusions. All missing blocks are padded to ensure conformability.
}
\section{Attributes Set}{

\describe{
\item{\code{A}}{Numeric matrix. Canonical design matrix constructed from
(C, S, M, Q).}
\item{\code{C_idx}}{Integer vector of length 2 indicating the size of
the C block.}
\item{\code{b}}{Numeric vector. Conformable right-hand side vector.}
}
}

