% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohenW.r
\name{cohenW}
\alias{cohenW}
\title{Cohen's w (omega)}
\usage{
cohenW(x, y = NULL, p = NULL, digits = 4, ...)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations for one dimension
of a two-way table.}

\item{y}{If \code{x} is a vector, \code{y} is the vector of observations for
the second dimension of a two-way table.}

\item{p}{If \code{x} is a vector of observed counts, \code{p} can be given as
a vector of expected probabilties,
as in a chi-square goodness of fit test.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to \code{chisq.test}.}
}
\value{
A single statistic, Cohen's w.
}
\description{
Calculates Cohen's w for a table of nominal variables.
}
\details{
Cohen's w is used as a measure of association
          between two nominal variables, or as an effect size
          for a chi-square test of association.  For a 2 x 2 table,
          the absolute value of the phi statistic is the same as
          Cohen's w.  
          The value of Cohen's w is not bound by 1 on the upper end.
          Here, the value is always positive.
}
\examples{
### Example with table
data(Anderson)
fisher.test(Anderson)
cohenW(Anderson)

### Example for goodness-of-fit
### Bird foraging example, Handbook of Biological Statistics
observed = c(70,   79,   3,    4)
expected = c(0.54, 0.40, 0.05, 0.01)
chisq.test(observed, p = expected)
cohenW(observed, p = expected)

### Example with two vectors
Species = c(rep("Species1", 16), rep("Species2", 16))
Color   = c(rep(c("blue", "blue", "blue", "green"),4),
            rep(c("green", "green", "green", "blue"),4))
fisher.test(Species, Color)
cohenW(Species, Color)

}
\references{
\url{http://rcompanion.org/handbook/H_10.html}
}
\seealso{
\code{\link{cramerV}} \code{\link{cramerVFit}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{correlation phi cohen w omega}
