% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalEtaSquared.r
\name{ordinalEtaSquared}
\alias{ordinalEtaSquared}
\title{Eta-squared for ordinal variables}
\usage{
ordinalEtaSquared(
  x,
  g = NULL,
  group = "row",
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  reportIncomplete = FALSE,
  ...
)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations of an ordinal variable.}

\item{g}{If \code{x} is a vector, \code{g} is the vector of observations for
the grouping, nominal variable.}

\item{group}{If \code{x} is a table or matrix, \code{group} indicates whether
the \code{"row"} or the \code{"column"} variable is
the nominal, grouping variable.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{reportIncomplete}{If \code{FALSE} (the default),
\code{NA} will be reported in cases where there
are instances of the calculation of the statistic
failing during the bootstrap procedure.}

\item{...}{Additional arguments passed to the \code{kruskal.test} function.}
}
\value{
A single statistic, eta-squared.
        Or a small data frame consisting of eta-squared,
        and the lower and upper confidence limits.
}
\description{
Calculates eta-squared 
             as an effect size statistic,
             following a Kruskal-Wallis test, 
             or for a table with one ordinal
             variable and one nominal variable; 
             confidence intervals by bootstrap.
}
\details{
Eta-squared is used as a measure of association
          for the Kruskal-Wallis test or for a two-way
          table with one ordinal and one nominal variable.

          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
          
          Because eta-squared is always positive, 
          if \code{type="perc"}, the confidence interval will
          never cross zero, and should not
          be used for statistical inference.
          However, if \code{type="norm"}, the confidence interval
          may cross zero. 
          
          When eta-squared is close to 0 or very large,
          or with small counts in some cells,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
data(Breakfast)
library(coin)
chisq_test(Breakfast, scores = list("Breakfast" = c(-2, -1, 0, 1, 2)))
ordinalEtaSquared(Breakfast)

data(PoohPiglet)
kruskal.test(Likert ~ Speaker, data = PoohPiglet)
ordinalEtaSquared(x = PoohPiglet$Likert, g = PoohPiglet$Speaker)

### Same data, as matrix of counts
data(PoohPiglet)
XT = xtabs( ~ Speaker + Likert , data = PoohPiglet)
ordinalEtaSquared(XT)

}
\references{
Cohen, B.H. 2013. Explaining Psychological Statistics, 4th ed. 
            Wiley.
            
            \url{https://rcompanion.org/handbook/F_08.html}
}
\seealso{
\code{\link{freemanTheta}}, 
         \code{\link{epsilonSquared}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Kruskal-Wallis}
\concept{effect size}
\concept{eta squared}
