% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\name{rws_connect}
\alias{rws_connect}
\alias{rws_open_connection}
\title{Opens SQLite Database Connection}
\usage{
rws_connect(dbname = ":memory:", exists = NA)
}
\arguments{
\item{dbname}{The path to the database file. SQLite keeps each database
instance in one single file. The name of the database \emph{is} the file
name, thus database names should be legal file names in the running
platform. There are two exceptions:

\itemize{
\item \code{""} will create a temporary on-disk database. The file
will be deleted when the connection is closed.
\item \code{":memory:"} or \code{"file::memory:"} will create a temporary
in-memory database.
}}

\item{exists}{A flag specifying whether the table(s) must already exist.}
}
\value{
A \linkS4class{SQLiteConnection} to a SQLite database with
foreign key constraints enabled.
}
\description{
Opens a \linkS4class{SQLiteConnection} to a SQLite database with
foreign key constraints enabled.
}
\examples{
conn <- rws_connect()
print(conn)
rws_disconnect(conn)
}
\seealso{
\code{\link[=rws_disconnect]{rws_disconnect()}}
}
