% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_package_information.R,
%   R/01_regmedint_class_ui.R
\docType{package}
\name{regmedint}
\alias{regmedint}
\title{regmedint: A package for regression-based causal mediation analysis}
\usage{
regmedint(
  data,
  yvar,
  avar,
  mvar,
  cvar,
  emm_ac_mreg = NULL,
  emm_ac_yreg = NULL,
  emm_mc_yreg = NULL,
  eventvar = NULL,
  a0,
  a1,
  m_cde,
  c_cond,
  mreg,
  yreg,
  interaction = TRUE,
  casecontrol = FALSE,
  na_omit = FALSE
)
}
\arguments{
\item{data}{Data frame containing the following relevant variables.}

\item{yvar}{A character vector of length 1. Outcome variable name. It should be the time variable for the survival outcome.}

\item{avar}{A character vector of length 1. Treatment variable name.}

\item{mvar}{A character vector of length 1. Mediator variable name.}

\item{cvar}{A character vector of length > 0. Covariate names. Use \code{NULL} if there is no covariate. However, this is a highly suspicious situation. Even if \code{avar} is randomized, \code{mvar} is not. Thus, there are usually some confounder(s) to account for the common cause structure (confounding) between \code{mvar} and \code{yvar}.}

\item{emm_ac_mreg}{A character vector of length > 0. Effect modifiers names. The covariate vector in treatment-covariate product term in the mediator model.}

\item{emm_ac_yreg}{A character vector of length > 0. Effect modifiers names. The covariate vector in treatment-covariate product term in the outcome model.}

\item{emm_mc_yreg}{A character vector of length > 0. Effect modifiers names. The covariate vector in mediator-covariate product term in outcome model.}

\item{eventvar}{An character vector of length 1. Only required for survival outcome regression models. Note that the coding is 1 for event and 0 for censoring, following the R survival package convention.}

\item{a0}{A numeric vector of length 1. The reference level of treatment variable that is considered "untreated" or "unexposed".}

\item{a1}{A numeric vector of length 1.}

\item{m_cde}{A numeric vector of length 1. Mediator level at which controlled direct effect is evaluated at.}

\item{c_cond}{A numeric vector of the same length as \code{cvar}. Covariate levels at which natural direct and indirect effects are evaluated at.}

\item{mreg}{A character vector of length 1. Mediator regression type: \code{"linear"} or \code{"logistic"}.}

\item{yreg}{A character vector of length 1. Outcome regression type: \code{"linear"}, \code{"logistic"}, \code{"loglinear"}, \code{"poisson"}, \code{"negbin"}, \code{"survCox"}, \code{"survAFT_exp"}, or \code{"survAFT_weibull"}.}

\item{interaction}{A logical vector of length 1. The presence of treatment-mediator interaction in the outcome model. Default to TRUE.}

\item{casecontrol}{A logical vector of length 1. Default to FALSE. Whether data comes from a case-control study.}

\item{na_omit}{A logical vector of length 1. Default to FALSE. Whether to remove NAs in the columns of interest before fitting the models.}
}
\value{
regmedint object, which is a list containing the mediator regression object, the outcome regression object, and the regression-based mediation results.
}
\description{
The package is an R implementation of regression-based closed-form causal mediation as originally described in Valeri & VanderWeele 2013 and Valeri & VanderWeele 2015 \url{https://www.hsph.harvard.edu/tyler-vanderweele/tools-and-tutorials/}. The earlier version is a sister program of the SAS macro. The current extended version (version 1.0 and later) supports effect modification by covariates (treatment-covariate and mediator-covariate product terms) in mediator and outcome models.

This is a user-interface for regression-based causal mediation analysis as described in Valeri & VanderWeele 2013 and Valeri & VanderWeele 2015.
}
\section{Fitting models}{

Use the regmedint function to fit models and set up regression-based causal mediation analysis.
}

\section{Examining results}{

Several methods are available to examine the regmedint object.
print
summary
coef
confint
}

\examples{
library(regmedint)
data(vv2015)
regmedint_obj1 <- regmedint(data = vv2015,
                            ## Variables
                            yvar = "y",
                            avar = "x",
                            mvar = "m",
                            cvar = c("c"),
                            eventvar = "event",
                            ## Values at which effects are evaluated
                            a0 = 0,
                            a1 = 1,
                            m_cde = 1,
                            c_cond = 3,
                            ## Model types
                            mreg = "logistic",
                            yreg = "survAFT_weibull",
                            ## Additional specification
                            interaction = TRUE,
                            casecontrol = FALSE)
summary(regmedint_obj1)

regmedint_obj2 <- regmedint(data = vv2015,
                            ## Variables
                            yvar = "y",
                            avar = "x",
                            mvar = "m",
                            cvar = c("c"),
                            emm_ac_mreg = c("c"), 
                            emm_ac_yreg = c("c"), 
                            emm_mc_yreg = c("c"), 
                            eventvar = "event",
                            ## Values at which effects are evaluated
                            a0 = 0,
                            a1 = 1,
                            m_cde = 1,
                            c_cond = 3,
                            ## Model types
                            mreg = "logistic",
                            yreg = "survAFT_weibull",
                            ## Additional specification
                            interaction = TRUE,
                            casecontrol = FALSE)
summary(regmedint_obj2)




}
