% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_style.R
\name{get_theme}
\alias{get_theme}
\title{Get a theme}
\usage{
get_theme(theme)
}
\arguments{
\item{theme}{A string that contains the desired theme name to return.
Valid values are "MidnightBlue", "SteelBlue", "DarkRed", "SeaGreen", 
"SlateGrey", "Plain", and "SASDefault".}
}
\description{
This function will return a style object for a specified theme.
There are currently seven themes available.  The returned object 
may be modifed and applied to a report using \code{\link{add_style}}.
}
\examples{
library(reporter)
library(magrittr)

# Get theme
tm <- get_theme("SteelBlue")

# View theme settings
print(tm)
## A style specification: 
#- font_name: 'Arial'
#- font_size: 10
#- text_color: 'DimGrey'
#- title_font_size: 11
#- title_font_bold: TRUE
#- title_font_color: 'SteelBlue'
#- border_color: 'Grey'
#- table_header_background: 'SteelBlue'
#- table_header_font_bold: TRUE
#- table_header_font_color: 'LightGrey'
#- table_body_background: 'White'
#- table_body_stripe: 'WhiteSmoke'
#- table_stub_background: 'SteelBlue'
#- table_stub_font_color: 'LightGrey'
#- table_stub_font_bold: TRUE

# Modify theme
tm$font_size <- 12
tm$title_font_size <- 13

# Create temp file path
tmp <- file.path(tempdir(), "HairAndEyes.html")

# Get data
dat <- as.data.frame(HairEyeColor)

# Create table object
tbl <- create_table(dat[dat$Freq >= 10, ], 
borders = "outside") \%>\% 
titles("Hair and Eye Colors")

# Use modified theme
rpt <- create_report(tmp, output_type = "HTML") \%>\% 
       add_content(tbl) \%>\% 
       add_style(tm)

# Write out the report        
write_report(rpt)

# Uncomment to View report
# file.show(tmp)

}
\seealso{
Other styles: 
\code{\link{add_style}()},
\code{\link{create_style}()},
\code{\link{print.style_spec}()}
}
\concept{styles}
