% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miniconda.R
\name{install_miniconda}
\alias{install_miniconda}
\title{Install Miniconda}
\usage{
install_miniconda(path = miniconda_path(), update = TRUE, force = FALSE)
}
\arguments{
\item{path}{The location where Miniconda is (or should be) installed. Note
that the Miniconda installer does not support paths containing spaces. See
\link{miniconda_path} for more details on the default path used by \code{reticulate}.}

\item{update}{Boolean; update to the latest version of Miniconda after
installation?}

\item{force}{Boolean; force re-installation if Miniconda is already installed
at the requested path?}
}
\description{
Download the \href{https://docs.conda.io/en/latest/miniconda.html}{Miniconda}
installer, and use it to install Miniconda.
}
\details{
For arm64 builds of R on macOS, \code{install_miniconda()} will use
binaries from \href{https://github.com/conda-forge/miniforge}{miniforge} instead.
}
\note{
If you encounter binary incompatibilities between R and Miniconda, a
scripted build and installation of Python from sources can be performed by
\code{\link[=install_python]{install_python()}}
}
\seealso{
Other miniconda-tools: 
\code{\link{miniconda_uninstall}()},
\code{\link{miniconda_update}()}
}
\concept{miniconda-tools}
