% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-objects.R
\name{iget}
\alias{iget}
\alias{ireadRDS}
\title{Retrieve File or Object from iRODS}
\usage{
iget(
  logical_path,
  local_path,
  offset = 0,
  count = 2000L,
  verbose = FALSE,
  overwrite = FALSE
)

ireadRDS(
  logical_path,
  offset = 0,
  count = 2000L,
  verbose = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{logical_path}{Source path in iRODS.}

\item{local_path}{Destination path in local storage.}

\item{offset}{Offset in bytes into the data object. Defaults to 0.}

\item{count}{Maximum number of bytes to write. Defaults to 2000.}

\item{verbose}{Whether information should be printed about the HTTP request
and response. Defaults to \code{FALSE}.}

\item{overwrite}{Whether the local file should be overwritten if it exists.
Defaults to \code{FALSE}.}
}
\value{
The R object in case of \code{ireadRDS()}, invisibly \code{NULL} in case of
\code{iget()}.
}
\description{
Transfer a file from iRODS to the local storage with \code{\link[=iget]{iget()}} or
read an R object from an RDS file in iRODS with \code{\link[=ireadRDS]{ireadRDS()}}
(see \code{\link[=readRDS]{readRDS()}}).
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

\dontshow{
.old_wd <- setwd(tempdir())
}
# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()

# connect project to server
create_irods("http://localhost/irods-rest/0.9.3", "/tempZone/home")

# authenticate
iauth("rods", "rods")

# save the iris dataset as csv and send the file to iRODS
write.csv(iris, "iris.csv")
iput("iris.csv", "iris.csv")

# bring the file back with a different name
iget("iris.csv", "newer_iris.csv")
file.exists("newer_iris.csv") # check that it has been transferred

# send an R object to iRODS in RDS format
isaveRDS(iris, "irids_in_rds.rds")

# read it back
iris_again <- ireadRDS("irids_in_rds.rds")
iris_again

# delete objects in iRODS
irm("irids_in_rds.rds", force = TRUE)
irm("iris.csv", force = TRUE)

\dontshow{
setwd(.old_wd)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=iput]{iput()}} for sending files,
\code{\link[=isaveRDS]{isaveRDS()}} for sending R objects to iRODS,
\code{\link[=saveRDS]{saveRDS()}} for an R equivalent.
}
