% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_host_info.R
\name{as_iso_date}
\alias{as_iso_date}
\title{Convert input to ISO 8601 date (YYYY-MM-DD)}
\usage{
as_iso_date(x)
}
\arguments{
\item{x}{A vector coercible to `Date` (e.g., character, `Date`, or `POSIXct`).
If `NULL`, the function returns `NULL`.}
}
\value{
A character vector the same length as `x` (or `NULL` if `x` is `NULL`)
with dates formatted as `"YYYY-MM-DD"`. Unparseable elements or `NA`s
become `NA_character_`.
}
\description{
Formats inputs as ISO 8601 calendar dates (`"YYYY-MM-DD"`).
}
\details{
Coercion uses [base::as.Date()], so time-of-day and timezone information are
dropped. For `POSIXct` inputs, the date is computed by `as.Date.POSIXct`
(which uses `tz = "UTC"` by default). Be aware that ambiguous character
dates (e.g., `"01/02/2024"`) depend on your R locale/format unless you
specify a format before calling this function.
}
\examples{
as_iso_date(Sys.Date())
as_iso_date(NULL)              
as_iso_date("not-a-date")

}
