% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoxInfo.R
\name{CoxFormula}
\alias{CoxFormula}
\alias{CoxFormula.cph}
\alias{CoxFormula.coxph}
\alias{CoxFormula.phreg}
\title{Extract the formula from a Cox model}
\usage{
CoxFormula(object)

\method{CoxFormula}{cph}(object)

\method{CoxFormula}{coxph}(object)

\method{CoxFormula}{phreg}(object)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}
}
\description{
Extract the formula from a Cox model
}
\examples{
\dontrun{
d <- sampleData(1e2, outcome = "survival")

##
library(survival)
mCox <- coxph(Surv(time, event) ~ X1+X2, data = d)
CoxFormula(mCox)

##
library(rms)
f <- Surv(time, event) ~ X1+X2
mCox <- cph(f, data = d, y = TRUE)
CoxFormula(mCox)
}
}
\author{
Brice Ozenne broz@sund.ku.dk
}
