% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_icons.R
\name{plot_icons}
\alias{plot_icons}
\title{Plot an icon array of a population.}
\usage{
plot_icons(prev = num$prev, sens = num$sens, mirt = NA,
  spec = num$spec, fart = NA, N = freq$N, arr_type = "array",
  by = "all", ident_order = c("hi", "mi", "fa", "cr"),
  icon_types = 22, icon_size = NULL, icon_brd_lwd = 1.5,
  block_d = NULL, border_d = 0.1, block_size_row = 10,
  block_size_col = 10, nblocks_row = NULL, nblocks_col = NULL,
  fill_array = "left", fill_blocks = "rowwise", lbl_txt = txt,
  title_lbl = txt$scen_lbl, cex_lbl = 0.9, col_pal = pal,
  transparency = 0.5, mar_notes = TRUE, ...)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{N}{The number of individuals in the population.
A suitable value of \code{\link{N}} is computed, if not provided.
If N is 100,000 or greater it is reduced to 10,000
for the array types if the frequencies allow it.}

\item{arr_type}{The icons can be arranged in different ways
resulting in different types of displays:

\enumerate{

  \item \code{arr_type = "array"}: Icons are plotted in a
  classical icon array (default).
  Icons can be arranged in blocks using \code{block_d}.
  The order of filling the array can be customized using
  \code{fill_array} and \code{fill_blocks}.

  \item \code{arr_type = "shuffledarray"}: Icons are plotted in an
  icon array, but positions are shuffled (randomized).
  Icons can be arranged in blocks using \code{block_d}.
  The order of filling the array can be customized using
  \code{fill_array} and \code{fill_blocks}.

  \item \code{arr_type = "mosaic"}: Icons are ordered like in a mosaic plot.
  The area size displays the relative proportions of their frequencies.

  \item \code{arr_type = "fillequal"}: Icons are positioned into equally sized blocks.
  Thus, their density reflects the relative proportions of their frequencies.

  \item \code{arr_type = "fillleft"}: Icons are randomly filled from the left.

  \item \code{arr_type = "filltop"}: Icons are randomly filled from the top.

  \item \code{arr_type = "scatter"}: Icons are randomly scattered into the plot.

}}

\item{by}{A character code specifying a perspective to split the population into subsets,
with 4 options:

  \enumerate{
  \item \code{"all"}: by condition (cd) and by decision (dc):

        \code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}} cases (default);

  \item \code{"cd"}: by condition (cd) only:

        \code{\link{cond_true}} vs. \code{\link{cond_false}} cases;

  \item \code{"dc"}: by decision (dc) only:

        \code{\link{dec_pos}} vs. \code{\link{dec_neg}} cases;

  \item \code{"ac"}: by accuracy (ac) only:

        \code{\link{dec_cor}} vs. \code{\link{dec_err}} cases.
  }}

\item{ident_order}{The order in which icon identities
(i.e., hi, mi, fa, and cr) are plotted.
Default: \code{ident_order = c("hi", "mi", "fa", "cr")}}

\item{icon_types}{Specifies the appearance of the icons as a vector.
Accepts values from 1 to 25 (see \code{?points}).}

\item{icon_size}{Manually specifies the size of the icons via \code{cex}
(calculated dynamically by default).}

\item{icon_brd_lwd}{Specifies the border width of icons (if applicable).}

\item{block_d}{The distance between blocks
(does not apply to "filleft", "filltop", and "scatter")}

\item{border_d}{The distance of icons to the border.

Additional options for controlling the arrangement of arrays
(for \code{arr_type = "array"} and \code{"shuffledarray"}):}

\item{block_size_row}{specifies how many icons should be in each block row.}

\item{block_size_col}{specifies how many icons should be in each block column.}

\item{nblocks_row}{specifies how many blocks there are in each row.  Is calculated by default.}

\item{nblocks_col}{specifies how many blocks are there in each column.  Is calculated by default.}

\item{fill_array}{specifies how the blocks are filled into the array
(Options "left" (default) and "top").}

\item{fill_blocks}{specifies how icons within blocks are filled
(Options: \code{fill_blocks = "rowwise"} (default) and \code{fill_blocks = "colwise"})

Generic text and color options:}

\item{lbl_txt}{Default label set for text elements.
Default: \code{lbl_txt = \link{txt}}.}

\item{title_lbl}{Text label for current plot title.
Default: \code{title_lbl = txt$scen_lbl}.}

\item{cex_lbl}{Scaling factor for text labels.
Default: \code{cex_lbl = .90}.}

\item{col_pal}{Color palette.
Default: \code{col_pal = \link{pal}}.}

\item{transparency}{Specifies the transparency for overlapping icons
(not for \code{arr_type = "array"} and \code{"shuffledarray"}).}

\item{mar_notes}{Boolean option for showing margin notes.
Default: \code{mar_notes = TRUE}.}

\item{...}{Other (graphical) parameters.}
}
\value{
Nothing (NULL).
}
\description{
\code{plot_icons} plots a population of which individual's
condition has been classified correctly or incorrectly as icons
from a sufficient and valid set of 3 essential probabilities
(\code{\link{prev}}, and
\code{\link{sens}} or its complement \code{\link{mirt}}, and
\code{\link{spec}} or its complement \code{\link{fart}})
or existing frequency information \code{\link{freq}}
and a population size of \code{\link{N}} individuals.
}
\details{
If probabilities are provided, a new list of
natural frequencies \code{\link{freq}} is computed by \code{\link{comp_freq}}.
By contrast, if no probabilities are provided,
the values currently contained in \code{\link{freq}} are used.
By default, \code{\link{comp_freq}} rounds frequencies to nearest integers
to avoid decimal values in \code{\link{freq}}.
}
\examples{
# ways to work:
plot_icons(N = 1000)  # icon array with default settings (arr_type = "array")
plot_icons(arr_type = "shuffledarray", N = 1000)  # icon array with shuffled IDs

# array types:
plot_icons(arr_type = "mosaic",    N = 1000)  # areas as in mosaic plot
plot_icons(arr_type = "fillequal", N = 1000)  # areas of equal size (probability as density)
plot_icons(arr_type = "fillleft",  N = 1000)  # icons filled from left to right (in columns)
plot_icons(arr_type = "filltop",   N = 1000)  # icons filled from top to bottom (in rows)
plot_icons(arr_type = "scatter",   N = 1000)  # icons randomly scattered

# by argument:
plot_icons(N = 1000, by = "all")  # hi, mi, fa, cr (TP, FN, FP, TN) cases
plot_icons(N = 1000, by = "cd")   # (hi + mi) vs. (fa + cr) (TP + FN vs. FP + TN) cases
plot_icons(N = 1000, by = "dc")   # (hi + fa) vs. (mi + cr) (TP + FP vs. FN + TN) cases
plot_icons(N = 1000, by = "ac")   # (hi + cr) vs. (fa + mi) (TP + TN vs. FP + FN) cases

# icon symbols:
plot_icons(N = 100, icon_types = c(21, 23, 24, 23),
               block_size_row = 5, block_size_col = 5, #nblocks_row = 2, nblocks_col = 2,
               block_d = 0.5, border_d = 0.9)

# variants:
plot_icons(N = 800, arr_type = "array", icon_types = c(21, 22, 23, 24),
           block_d = 0.5, border_d = 0.5)

plot_icons(N = 1250, sens = 0.9, spec = 0.9, prev = 0.9,
               icon_types = c(21, 23, 24, 23),
               block_size_row = 10, block_size_col = 5,
               nblocks_row = 5, nblocks_col = 5,
               block_d = 0.8,
               border_d = 0.2,
               fill_array = "top")

plot_icons(N = 800, arr_type = "shuffledarray", icon_types = c(21, 23, 24, 22),
           block_d = 0.5, border_d = 0.5)

plot_icons(N = 800, arr_type = "shuffledarray", icon_types = c(21, 23, 24, 22),
           icon_brd_col = grey(.33, .99), icon_brd_lwd = 3, cex_lbl = 1.2)

plot_icons(N = 800, arr_type = "fillequal", icon_types = c(21, 22, 22, 21),
           icon_brd_lwd = .5, cex = 1, cex_lbl = 1.1)

# Text and color options:
plot_icons(N = 1000, prev = .5, sens = .5, spec = .5, arr_type = "shuffledarray",
           title_lbl = "", lbl_txt = txt_TF, col_pal = pal_vir, mar_notes = FALSE)

plot_icons(N = 1000, prev = .5, sens = .5, spec = .5, arr_type = "shuffledarray",
           title_lbl = "Green vs. red", col_pal = pal_rgb, transparency = .5)

plot_icons(N = 1000, prev = .5, sens = .5, spec = .5, arr_type = "shuffledarray",
           title_lbl = "Shades of blue", col_pal = pal_kn, transparency = .3)

}
\seealso{
Other visualization functions: \code{\link{plot.riskyr}},
  \code{\link{plot_area}}, \code{\link{plot_bar}},
  \code{\link{plot_curve}}, \code{\link{plot_fnet}},
  \code{\link{plot_mosaic}}, \code{\link{plot_plane}},
  \code{\link{plot_prism}}, \code{\link{plot_tab}},
  \code{\link{plot_tree}}
}
\concept{visualization functions}
