% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{plot.rq.pen.seq}
\alias{plot.rq.pen.seq}
\title{Plot of coefficients of rq.pen.seq object as a function of lambda}
\usage{
\method{plot}{rq.pen.seq}(
  x,
  vars = NULL,
  logLambda = TRUE,
  tau = NULL,
  a = NULL,
  lambda = NULL,
  modelsIndex = NULL,
  lambdaIndex = NULL,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{rq.pen.seq object}

\item{vars}{Variables of interest}

\item{logLambda}{Whether lambda should be reported on the log scale}

\item{tau}{Quantiles of interest}

\item{a}{Tuning parameter a values of interest.}

\item{lambda}{Values of lambda of interest.}

\item{modelsIndex}{Specific models of interest.}

\item{lambdaIndex}{Specific lambda values of interest.}

\item{main}{Title of the plots. Can be a vector of multiple titles if multiple plots are created.}

\item{...}{Additional arguments sent to plot}
}
\value{
Returns plot(s) of coefficients as they change with lambda.
}
\description{
Plot of coefficients of rq.pen.seq object as a function of lambda
}
\examples{
set.seed(1)
x <- matrix(rnorm(100*8,sd=10),ncol=8)
y <- 1 + x[,1] + 3*x[,3] - x[,8] + rt(100,3)
m1 <- rq.pen(x,y,tau=c(.1,.5,.7),penalty="SCAD",a=c(3,4))
plot(m1,a=3,tau=.7)
plot(m1)
mlist <- list()
for(i in 1:6){
mlist[[i]] <- paste("Plot",i)
}
plot(m1,main=mlist)
}
\author{
Ben Sherwood, \email{ben.sherwood@ku.edu}
}
