% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTwoFactor.r
\name{plotTwoFactor}
\alias{plotTwoFactor}
\title{Bar plot of gene expression for two-factor experiments}
\usage{
plotTwoFactor(
  data,
  x_col,
  y_col,
  group_col,
  Lower.se_col,
  Upper.se_col,
  letters_col = NULL,
  letters_d = 0.2,
  dodge_width = 0.8,
  col_width = 0.8,
  err_width = 0.15,
  fill_colors = NULL,
  alpha = 1,
  base_size = 12,
  legend_position = "right",
  ...
)
}
\arguments{
\item{data}{A data frame containing expression results, typically obtained from
\code{ANOVA_DDCt()} or \code{ANOVA_DCt()}.}

\item{x_col}{Integer specifying the column number used for the x-axis factor.}

\item{y_col}{Integer specifying the column number used for the bar height
(relative expression or fold change).}

\item{group_col}{Integer specifying the column number used for grouping bars
(fill aesthetic).}

\item{Lower.se_col}{Integer specifying the column number used for the lower limit
of the error bar.}

\item{Upper.se_col}{Integer specifying the column number used for the upper limit
of the error bar.}

\item{letters_col}{Integer specifying the column number containing grouping letters
from statistical comparisons.}

\item{letters_d}{Numeric specifying the distance between sig letters and error bar.}

\item{dodge_width}{Numeric. Width of the dodge position adjustment for grouped bars.}

\item{col_width}{Numeric. Width of bars (default 0.8)}

\item{err_width}{Numeric. Width of error bars (default 0.15)}

\item{fill_colors}{Optional vector of fill colors}

\item{alpha}{Numeric. Transparency of bars (default 1)}

\item{base_size}{Numeric. Base font size (default 12)}

\item{legend_position}{Character or numeric vector. Position of legend (default "right")}

\item{...}{Additional ggplot2 layer arguments (e.g., fill, alpha, color)}
}
\value{
A ggplot object
}
\description{
Creates a bar plot of relative gene expression (fold change) values
from a two-factor experiment, including error bars and statistical
significance annotations.
}
\details{
The \code{plotTwoFactor} function generates a bar plot of average
fold change (relative expression) values for target genes using
expression tables produced by functions such as
\code{ANOVA_DDCt()} or \code{ANOVA_DCt()}.
One factor is mapped to the x-axis and the second factor is used
to group the bars (fill aesthetic). Error bars represent standard
error (SE) or 95\% confidence intervals (CI). Optional grouping
letters from post hoc statistical comparisons can be displayed.
}
\examples{

a <- ANOVA_DCt(data_2factorBlock, block = "Block", numberOfrefGenes = 1)
data <- a$Results

p1 <- plotTwoFactor(
  data = data,
  x_col = 2,
  y_col = 3,
  group_col = 1,
  Lower.se_col = 8,
  Upper.se_col = 9,
  letters_col = 12,
  letters_d = 0.2,
  fill_colors = c("aquamarine4", "gold2"),
  alpha = 1,
  col_width = 0.7,
  dodge_width = 0.7,
  base_size = 16, 
  legend_position = c(0.2, 0.8)
)
p1


p2 <- plotTwoFactor(
  data = data,
  x_col = 2,
  y_col = 4,
  group_col = 1,
  Lower.se_col = 10,
  Upper.se_col = 11,
  letters_col = 12,
  letters_d = 0.2,
  fill_colors = c("aquamarine4", "gold2"),
  alpha = 1,
  col_width = 0.7,
  dodge_width = 0.7,
  base_size = 16, 
  legend_position = c(0.2, 0.8)
)
p2
}
\author{
Ghader Mirzaghaderi
}
