% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_list_report_instances}
\alias{sf_list_report_instances}
\title{List report instances}
\usage{
sf_list_report_instances(report_id, as_tbl = TRUE, verbose = FALSE)
}
\arguments{
\item{report_id}{\code{character}; the Salesforce Id assigned to a created
analytics report. It will start with \code{"00O"}.}

\item{as_tbl}{\code{logical}; an indicator of whether to convert the parsed
JSON into a \code{tbl_df}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df} by default, or a \code{list} depending on the value of
argument \code{as_tbl}
}
\description{
\lifecycle{experimental}

Returns a list of instances for a report that you requested to be run asynchronously.
Each item in the list is treated as a separate instance of the report run with
metadata in that snapshot of time.
}
\examples{
\dontrun{
# first, get the Id of a report in your Org
all_reports <- sf_query("SELECT Id, Name FROM Report")
this_report_id <- all_reports$Id[1]

# second, execute an async report
results <- sf_execute_report(this_report_id, async=TRUE)

# third, pull a list of async requests ("instances") usually meant for checking 
# if a recently requested report has succeeded and the results can be retrieved
instance_list <- sf_list_report_instances(this_report_id)
instance_status <- instance_list[[which(instance_list$id == results$id), "status"]]
}
}
\seealso{
\href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_instances_resource.htm}{Salesforce Documentation}, \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_list_asyncreportruns.htm#example_async_fetchresults_instances}{Salesforce Example}
}
