% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scR.R
\name{loss}
\alias{loss}
\title{Utility function to define the least-squares loss function to be optimized for \code{\link[=simvcd]{simvcd()}}}
\usage{
loss(h, ngrid, xi, a = 0.16, a1 = 1.2, a11 = 0.14927)
}
\arguments{
\item{h}{A positive real number giving the current guess at VC dimension}

\item{ngrid}{Vector of sample sizes for which the bounding function is estimated.}

\item{xi}{Vector of estimated values of the bounding function, usually obtained from \code{\link[=risk_bounds]{risk_bounds()}}}

\item{a}{Scaling coefficient for the bounding function. Defaults to the value given by Vapnik, Levin and Le Cun 1994.}

\item{a1}{Scaling coefficient for the bounding function. Defaults to the value given by Vapnik, Levin and Le Cun 1994.}

\item{a11}{Scaling coefficient for the bounding function. Defaults to the value given by Vapnik, Levin and Le Cun 1994.}
}
\value{
A real number giving the estimated value of the MSE given the current guess.
}
\description{
Utility function to define the least-squares loss function to be optimized for \code{\link[=simvcd]{simvcd()}}
}
\seealso{
\code{\link[=simvcd]{simvcd()}}, the user-facing function for simulating VC dimension and \code{\link[=risk_bounds]{risk_bounds()}} to generate estimates for xi.
}
