semtree
=======

[![cran
version](http://www.r-pkg.org/badges/version/semtree)](https://cran.r-project.org/package=semtree)
[![rstudio mirror
downloads](http://cranlogs.r-pkg.org/badges/semtree)](https://github.com/metacran/cranlogs.app)
[![codecov.io](https://codecov.io/github/brandmaier/semtree/coverage.svg?branch=master)](https://codecov.io/github/brandmaier/semtree?branch=master)

What is this?
-------------

An R package for estimating Structural Equation Model Trees and Forests.

Install
-------

To install the latest semtree package directly from GitHub, copy the
following line into R:

    library(devtools)
    devtools::install_github("semtree","brandmaier")

Usage
-----

Please see official semtree website: <http://brandmaier.de/semtree>

References
----------

Theory and method:

Brandmaier, A. M., Driver, C., & Voelkle, M. C. (in press). Recursive
partitioning in continuous time analysis. In K. van Montfort, J. Oud, &
M. C. Voelkle (Eds.), Continuous time modeling in the behavioral and
related sciences. New York: Springer.

Brandmaier, A. M., Prindle, J. J., McArdle, J. J., & Lindenberger, U.
(2016). Theory-guided exploration with structural equation model
forests. Psychological Methods, 21, 566-582.

Brandmaier, A. M., von Oertzen, T., McArdle, J. J., & Lindenberger, U.
(2014). Exploratory data mining with structural equation model trees. In
J. J. McArdle & G. Ritschard (Eds.), Contemporary issues in exploratory
data mining in the behavioral sciences (pp. 96-127). New York:
Routledge.

Brandmaier, A. M., von Oertzen, T., McArdle, J. J., & Lindenberger, U.
(2013). Structural equation model trees. Psychological Methods, 18,
71-86.

Applied examples:

Brandmaier, A. M., Ram, N., Wagner, G. G., & Gerstorf, D. (in press).
Terminal decline in well-being: The role of multi-indicator
constellations of physical health and psychosocial correlates.
Developmental Psychology.
