% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{effectiveSampleSize}
\alias{effectiveSampleSize}
\title{Compute the effective sample size (ESS) of the particles.}
\usage{
effectiveSampleSize(log_weights)
}
\arguments{
\item{log_weights}{logarithms of the importance weights of each particle.}
}
\value{
the effective sample size, a scalar between 0 and Q
}
\description{
The ESS is a "rule of thumb" for assessing the degeneracy of
the importance distribution:
\deqn{ESS = \frac{(\sum_{q=1}^Q w_q)^2}{\sum_{q=1}^Q w_q^2}}
}
\examples{
x <- runif(100)
effectiveSampleSize(log(x))
}
\references{
Liu, JS (2001) "Monte Carlo Strategies in Scientific Computing." Springer, NY, pp. 34--36.
}
