% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{ClusteringAlgo}
\alias{ClusteringAlgo}
\title{(Weighted) clustering algorithm}
\usage{
ClusteringAlgo(
  xdata,
  nc = NULL,
  eps = NULL,
  Lambda = NULL,
  scale = TRUE,
  row = TRUE,
  implementation = HierarchicalClustering,
  ...
)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.}

\item{nc}{matrix of parameters controlling the number of clusters in the
underlying algorithm specified in \code{implementation}. If \code{nc} is
not provided, it is set to \code{seq(1, nrow(xdata))}.}

\item{eps}{radius in density-based clustering, see
\code{\link[dbscan]{dbscan}}. Only used if
\code{implementation=DBSCANClustering}.}

\item{Lambda}{vector of penalty parameters.}

\item{scale}{logical indicating if the data should be scaled to ensure that
all variables contribute equally to the clustering of the observations.}

\item{row}{logical indicating if rows (if \code{row=TRUE}) or columns (if
\code{row=FALSE}) contain the items to cluster.}

\item{implementation}{function to use for clustering. Possible functions
include \code{\link{HierarchicalClustering}} (hierarchical clustering),
\code{\link{PAMClustering}} (Partitioning Around Medoids),
\code{\link{KMeansClustering}} (k-means) and \code{\link{GMMClustering}}
(Gaussian Mixture Models). Alternatively, a user-defined function taking
\code{xdata} and \code{Lambda} as arguments and returning a binary and
symmetric matrix for which diagonal elements are equal to zero can be used.}

\item{...}{additional parameters passed to the function provided in
\code{implementation}.}
}
\value{
A list with: \item{selected}{matrix of binary selection status. Rows
  correspond to different model parameters. Columns correspond to
  predictors.} \item{weight}{array of model coefficients. Rows correspond to
  different model parameters. Columns correspond to predictors. Indices along
  the third dimension correspond to outcome variable(s).}
  \item{comembership}{array of model coefficients. Rows correspond to
  different model parameters. Columns correspond to predictors. Indices along
  the third dimension correspond to outcome variable(s).}
}
\description{
Runs the (weighted) clustering algorithm specified in the argument
\code{implementation} and returns matrices of variable weights, and the
co-membership structure. This function is not using stability.
}
\examples{

# Simulation of 15 observations belonging to 3 groups
set.seed(1)
simul <- SimulateClustering(
  n = c(5, 5, 5), pk = 100
)

# Running hierarchical clustering
myclust <- ClusteringAlgo(
  xdata = simul$data, nc = 2:5,
  implementation = HierarchicalClustering
)

}
\seealso{
\code{\link{VariableSelection}}

Other underlying algorithm functions: 
\code{\link{CART}()},
\code{\link{PenalisedGraphical}()},
\code{\link{PenalisedOpenMx}()},
\code{\link{PenalisedRegression}()}
}
\concept{underlying algorithm functions}
