% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods__token.R
\name{refresh_token}
\alias{refresh_token}
\title{Refresh an OAuth 2.0 token}
\usage{
refresh_token(oauth_client, token, async = FALSE, introspect = FALSE)
}
\arguments{
\item{oauth_client}{\link{OAuthClient} object}

\item{token}{\link{OAuthToken} object containing the refresh token}

\item{async}{Logical, default FALSE. If TRUE and the \code{promises} package is
available, the refresh is performed off the main R session using
\code{promises::future_promise()} and this function returns a promise that
resolves to an updated \code{OAuthToken}. If \code{promises} is not available, falls
back to synchronous behavior}

\item{introspect}{Logical, default FALSE. After a successful refresh, if the
provider exposes an introspection endpoint, perform a best-effort
introspection of the new access token for audit/diagnostics. The result
is not stored on the token object.}
}
\value{
An updated \link{OAuthToken} object with a new access token. If the
provider issues a new refresh token, that replaces the old one. When the
provider returns an ID token and \code{id_token_validation = TRUE}, it is
validated. When \code{userinfo_required = TRUE}, fresh userinfo is fetched and
stored on the token. \code{expires_at} is computed from \code{expires_in} when
provided; otherwise set to \code{Inf}.
}
\description{
Refreshes an OAuth 2.0 access token using a refresh token.
}
\examples{
# Please note: `get_userinfo()`, `introspect_token()`, and `refresh_token()`
# are typically not called by users of this package directly, but are called
# internally by `oauth_module_server()`. These functions are exported
# nonetheless for advanced use cases. Most users will not need to
# call these functions directly

# Example requires a real token from a completed OAuth flow
# (code is therefore not run; would error with placeholder values below)
\dontrun{
# Define client
client <- oauth_client(
  provider = oauth_provider_github(),
  client_id = Sys.getenv("GITHUB_OAUTH_CLIENT_ID"),
  client_secret = Sys.getenv("GITHUB_OAUTH_CLIENT_SECRET"),
  redirect_uri = "http://127.0.0.1:8100"
)

# Have a valid OAuthToken object; fake example below
# (typically provided by `oauth_module_server()` or `handle_callback()`)
token <- handle_callback(client, "<code>", "<payload>", "<browser_token>")

# Get userinfo
user_info <- get_userinfo(client, token)

# Introspect token (if supported by provider)
introspection <- introspect_token(client, token)

# Refresh token
new_token <- refresh_token(client, token, introspect = TRUE)
}
}
