% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/args_filter_input.R
\name{args_filter_input}
\alias{args_filter_input}
\alias{args_update_filter_input}
\title{Derive Arguments for \pkg{shiny} Inputs}
\usage{
args_filter_input(x, ...)

args_update_filter_input(x, ...)
}
\arguments{
\item{x}{The object being passed to \code{\link[=filterInput]{filterInput()}} or \code{\link[=updateFilterInput]{updateFilterInput()}}.}

\item{...}{Additional arguments passed to the method. See details.}
}
\value{
A named list of arguments for a \pkg{shiny} input function
}
\description{
Provides the appropriate function arguments for the input function selected
by \code{\link[=filterInput]{filterInput()}} or \code{\link[=updateFilterInput]{updateFilterInput()}}.
}
\details{
The following arguments are supported in \code{...}:
\tabular{ll}{
\code{range} \tab
\emph{(Date, POSIXt)}. Logical. If \code{TRUE}, \code{args_filter_input()} will provide
the arguments for range date inputs. Only applies when \code{x} is of class
\code{Date} or \code{POSIXt}. \cr

\code{textbox} \tab
\emph{(character)}. Logical. If \code{FALSE} (the default), \code{args_filter_input()}
will provide the arguments for select inputs. \cr

\code{choices_asis} \tab
\emph{(character, factor, list, logical)}. Logical. If \code{TRUE}, the choices
provided to select inputs will not be modified. If \code{FALSE} (the default),
duplicate values will be removed and the choices will be sorted. Only
applies when \code{x} is of class \code{character}, \code{factor}, \code{list}, or
\code{logical}. \cr

\code{server} \tab
If \code{TRUE}, indicates that the choices will be provided server-side. In
this case, arguments are not computed for \code{args_filter_input()}. Ignored
in \code{args_update_filter_input()}. \cr
}
}
\examples{
args_filter_input(iris$Petal.Length)

}
