% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wait_until.R
\name{wait_n}
\alias{wait_n}
\alias{wait_until}
\title{Wait a Number of Signals}
\usage{
wait_n(.trj, n = 1)

wait_until(.trj, signals, n = 1)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{n}{number of \code{wait} activities to chain.}

\item{signals}{signal or list of signals, accepts either a string, a list of strings or a
callable object (a function) which must return a string or a list of strings.}
}
\value{
\code{wait_n} returns \code{n} times \code{\link[simmer:send]{wait}}.
\code{wait_until} also adds \code{\link[simmer:send]{trap}} and
\code{\link[simmer:send]{untrap}} at the beginning and end, respectively,
of the chain of \code{wait}s (see examples below).
}
\description{
These bricks encapsulate \code{n} stops: wait for a sequence of \code{n}
signals. \code{wait_until} also traps and untraps the required signals.
}
\examples{
## These are equivalent:
trajectory() \%>\%
  wait_n(3)

trajectory() \%>\%
  wait() \%>\%
  wait() \%>\%
  wait()

## These are equivalent:
trajectory() \%>\%
  wait_until("green")

trajectory() \%>\%
  trap("green") \%>\%
  wait() \%>\%
  untrap("green")

## These are equivalent:
trajectory() \%>\%
  wait_until(c("one", "another"), 2)

trajectory() \%>\%
  trap(c("one", "another")) \%>\%
  wait() \%>\%
  wait() \%>\%
  untrap(c("one", "another"))

}
