% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_viz.simmr_output.R
\name{prior_viz}
\alias{prior_viz}
\title{Plot the prior distribution for a simmr run}
\usage{
prior_viz(
  simmr_out,
  group = 1,
  plot = TRUE,
  include_posterior = TRUE,
  n_sims = 10000,
  ggargs = NULL
)
}
\arguments{
\item{simmr_out}{A run of the simmr model from \code{\link{simmr_mcmc}}}

\item{group}{Which group to run it for (currently only numeric rather than group names)}

\item{plot}{Whether to create a density plot of the prior or not. The simulated prior values are returned as part of the object}

\item{include_posterior}{Whether to include the posterior distribution on top of the priors. Defaults to TRUE}

\item{n_sims}{The number of simulations from the prior distribution}

\item{ggargs}{Extra arguments to be included in the ggplot (e.g. axis limits)}
}
\description{
This function takes the output from \code{\link{simmr_mcmc}} and plots the prior distribution to enable visual inspection. This can be used by itself or as part of \code{\link{posterior_predictive}} to visually evaluate the influence of the prior on the posterior distribution.
}
\examples{
\dontrun{
data(geese_data_day1)
simmr_1 <- with(
  geese_data_day1,
  simmr_load(
    mixtures = mixtures,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot
plot(simmr_1)

# Print
simmr_1

# MCMC run
simmr_1_out <- simmr_mcmc(simmr_1)

# Prior predictive
prior <- prior_viz(simmr_1_out)
head(prior)
summary(prior)
}
}
