% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_cluster.R
\name{sits_cluster_clean}
\alias{sits_cluster_clean}
\title{Removes labels that are minority in each cluster.}
\usage{
sits_cluster_clean(samples)
}
\arguments{
\item{samples}{Tibble with set of time series with additional
cluster information produced
by \code{\link[=sits_cluster_dendro]{sits_cluster_dendro()}}}
}
\value{
Tibble with time series (class "sits")
}
\description{
Takes a tibble with time series
that has an additional `cluster` produced by
\code{\link[=sits_cluster_dendro]{sits_cluster_dendro()}}
and removes labels that are minority in each cluster.
}
\examples{
if (sits_run_examples()) {
    clusters <- sits_cluster_dendro(cerrado_2classes)
    freq1 <- sits_cluster_frequency(clusters)
    freq1
    clean_clusters <- sits_cluster_clean(clusters)
    freq2 <- sits_cluster_frequency(clean_clusters)
    freq2
}
}
\author{
Rolf Simoes, \email{rolfsimoes@gmail.com}
}
