% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_area_geo}
\alias{plot_area_geo}
\title{Generar gráfico de distribución de casos por área geográfica}
\usage{
plot_area_geo(data_agrupada, col_area = "area", fuente_data = NULL)
}
\arguments{
\item{data_agrupada}{Un `data.frame` que contiene los datos de la
enfermedad o evento agrupados.}

\item{col_area}{Un `character` (cadena de caracteres) con el nombre de
la columna con el área geográfica en los datos agrupados de la enfermedad
o evento; su valor por defecto es `"area"`.}

\item{fuente_data}{Un `character` (cadena de caracteres) que contiene la
leyenda o fuente de información de los datos; su valor por defecto
es `NULL`.}
}
\value{
Un `plot` o gráfico de distribución de casos por área geográfica.
}
\description{
Función que genera el gráfico de casos por área geográfica.
}
\examples{
\donttest{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(dengue2020)
data_agrupada <- agrupar_area_geo(data_event = data_limpia)
plot_area_geo(data_agrupada,
  col_area = "area"
)
}
}
