% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta_sq.R
\name{eta_sq}
\alias{eta_sq}
\title{Eta-squared of fitted anova}
\usage{
eta_sq(...)
}
\arguments{
\item{...}{Fitted one-way-anova model or a dependent and grouping variable (see 'Examples').}
}
\value{
The eta-squared value.
}
\description{
Returns the eta-squared value for one-way-anovas.
}
\note{
Interpret eta-squared like r-squared or R-squared; a rule of thumb (Cohen):
        \itemize{
         \item .02 ~ small
         \item .13 ~ medium
         \item .26 ~ large
        }
}
\examples{
# load sample data
data(efc)

# fit linear model
fit <- aov(c12hour ~ as.factor(e42dep), data = efc)

# print eta sqaured
eta_sq(fit)

# grouping variable will be converted to factor autoamtically
eta_sq(efc$c12hour, efc$e42dep)

}
\references{
\itemize{
              \item \href{http://stats.stackexchange.com/questions/78808/}{How to compute eta-sq in ANOVA by hand?}
              \item \href{http://stats.stackexchange.com/questions/15958/}{How to interpret and report eta squared?}
              \item \href{http://en.wikiversity.org/wiki/Eta-squared}{Wikipedia: Eta-squared}
              \item Levine TR, Hullett CR (2002): Eta Squared, Partial Eta Squared, and Misreporting of Effect Size in Communication Research (\href{https://www.msu.edu/~levinet/eta\%20squared\%20hcr.pdf}{pdf})
            }
}

