% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen.summary.R
\name{eigen.summary}
\alias{eigen.summary}
\title{Summarize Eigenvalues and Eigenvectors of a Covariance Matrix}
\usage{
eigen.summary(
  cov.matrix,
  caption = "Eigenvectors of Covariance Matrix",
  space_after_caption = "5mm"
)
}
\arguments{
\item{cov.matrix}{A square numeric matrix representing the covariance matrix.}

\item{caption}{A character string specifying the table caption (default: "Eigenvectors of Covariance Matrix").}

\item{space_after_caption}{A character string specifying the space after the caption in LaTeX (default: "5mm").}
}
\value{
A LaTeX formatted table displaying the eigenvectors and eigenvalues.
}
\description{
This function computes the eigenvalues and eigenvectors of a given covariance matrix,
ensures sign consistency in the eigenvectors, and outputs a formatted LaTeX table
displaying the results.
}
\examples{
cov_matrix <- matrix(c(4, 2, 2, 3), nrow = 2)
eigen.summary(cov_matrix)
}
