% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_sequences.R
\name{seq_press_2d_shaped}
\alias{seq_press_2d_shaped}
\title{PRESS sequence with shaped refocusing pulses.}
\usage{
seq_press_2d_shaped(
  spin_params,
  ft,
  ref,
  TE1 = 0.01,
  TE2 = 0.02,
  pulse_file,
  pulse_dur,
  pulse_file_format,
  refoc_flip_angle = 180,
  xy_pulse_ppm = NULL,
  resamp = TRUE,
  fs_resamp = 1e-04
)
}
\arguments{
\item{spin_params}{spin system definition.}

\item{ft}{transmitter frequency in Hz.}

\item{ref}{reference value for ppm scale.}

\item{TE1}{TE1 sequence parameter in seconds (TE=TE1+TE2).}

\item{TE2}{TE2 sequence parameter in seconds.}

\item{pulse_file}{path to refocusing pulse file.}

\item{pulse_dur}{refocusing pulse duration.}

\item{pulse_file_format}{file format for the refocusing pulse.}

\item{refoc_flip_angle}{refocusing pulse flip angle in degrees (defaults to
180).}

\item{xy_pulse_ppm}{a vector of ppm values for the offset of each
sub-simulation.}

\item{resamp}{option to resample the pulse shape.}

\item{fs_resamp}{sampling frequency (Hz) to resample.}
}
\value{
list of resonance amplitudes and frequencies.
}
\description{
PRESS sequence with shaped refocusing pulses.
}
