% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efast_sampling_netlogo.R
\name{efast_generate_sample_netlogo}
\alias{efast_generate_sample_netlogo}
\title{Prepares Netlogo experiment files for a variance-based sensitivity analysis,
using eFAST}
\usage{
efast_generate_sample_netlogo(FILEPATH, NUMCURVES, NUMSAMPLES, MEASURES,
  PARAMETERS, PARAMVALS, EXPERIMENT_REPETITIONS, RUNMETRICS_EVERYSTEP,
  NETLOGO_SETUP_FUNCTION, NETLOGO_RUN_FUNCTION)
}
\arguments{
\item{FILEPATH}{Directory where the parameter samples and XML models are to
be stored}

\item{NUMCURVES}{The number of 'resamples' to perform (see eFAST
documentation) - recommend using at least 3.}

\item{NUMSAMPLES}{The number of parameter subsets to be generated for each
curve in the eFAST design.}

\item{MEASURES}{Array containing the names of the Netlogo output measures
which are used to analyse the simulation.}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{PARAMVALS}{Array containing either the parameter value (if not of
interest in the analysis), or range under which this is being explored
 (stated as as string e.g. "[5,50,5]" for a range of 5-50, increment of 5).
 The reader should read the relevant tutorial in detail.}

\item{EXPERIMENT_REPETITIONS}{The number of times Netlogo should repeat the
experiment for each set of parameter values.}

\item{RUNMETRICS_EVERYSTEP}{Boolean stating whether Netlogo should produce
output for each timestep.}

\item{NETLOGO_SETUP_FUNCTION}{The name of the function in Netlogo that sets
up the simulation. Commonly is named setup.}

\item{NETLOGO_RUN_FUNCTION}{The name of the function in Netlogo that starts
the simulation. Commonly named go.}
}
\description{
Creates a set of parameter values, over the specified value space, using the
sampling method described in the eFAST technique. Then processes each of
these into a Netlogo experiment XML file, from which a simulation can be run.
}
