% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efast_analysis.R
\name{efast_run_Analysis_from_DB}
\alias{efast_run_Analysis_from_DB}
\title{Runs the eFAST Analysis for a set of results stored in a database}
\usage{
efast_run_Analysis_from_DB(efast_sim_results, number_samples, parameters,
  number_curves, measures, OUTPUTMEASURES_TO_TTEST = 1:length(measures),
  TTEST_CONF_INT = 0.95)
}
\arguments{
\item{efast_sim_results}{Set of simulation results mined from the database,
put into the format required by spartan}

\item{number_samples}{Number of samples taken per parameter}

\item{parameters}{Array containing the names of the parameters of which
parameter samples have been generated}

\item{number_curves}{The number of 'resamples' to perform (see eFAST
documentation) - recommend using at least 3}

\item{measures}{Array containing the names of the output measures which
are used to analyse the simulation}

\item{OUTPUTMEASURES_TO_TTEST}{Which measures in the range should be tested
to see if the result is statistically significant.  To do all, and if
there were 3 measures, this would be set to 1:3}

\item{TTEST_CONF_INT}{The level of significance to use for the T-Test
(e.g. 0.95)}
}
\description{
Produces a file summarising the analysis; partitioning the variance between
parameters and providing relevant statistics. These include, for each
parameter of interest, first-order sensitivity index (Si), total-order
sensitivity index (STi), complementary parameters sensitivity index (SCi),
and relevant p-values and error bar data calculated using a two-sample
t-test and standard error respectively. For a more detailed examination of
 this analysis, see the references in the R Journal paper. For ease of
 representation, the method also produces a graph showing this data for
 each simulation output measure. In this case, this function works with
 spartanDB to analyse data stored in a database
}
