% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdplyr-Spatial.r
\name{dplyr-Spatial}
\alias{dplyr-Spatial}
\alias{dplyr-Spatial}
\alias{mutate.Spatial}
\alias{dplyr-Spatial}
\alias{mutate_.Spatial}
\alias{dplyr-Spatial}
\alias{summarise_.Spatial}
\alias{dplyr-Spatial}
\alias{summarise.Spatial}
\alias{dplyr-Spatial}
\alias{group_by_.Spatial}
\alias{dplyr-Spatial}
\alias{group_by.Spatial}
\alias{dplyr-Spatial}
\alias{filter_.Spatial}
\alias{dplyr-Spatial}
\alias{filter.Spatial}
\alias{dplyr-Spatial}
\alias{arrange_.Spatial}
\alias{dplyr-Spatial}
\alias{arrange.Spatial}
\alias{dplyr-Spatial}
\alias{slice_.Spatial}
\alias{dplyr-Spatial}
\alias{slice.Spatial}
\alias{dplyr-Spatial}
\alias{select_.Spatial}
\alias{dplyr-Spatial}
\alias{select.Spatial}
\alias{dplyr-Spatial}
\alias{rename_.Spatial}
\alias{dplyr-Spatial}
\alias{rename.Spatial}
\alias{dplyr-Spatial}
\alias{distinct_.Spatial}
\alias{dplyr-Spatial}
\alias{distinct.Spatial}
\alias{dplyr-Spatial}
\alias{left_join.Spatial}
\alias{dplyr-Spatial}
\alias{inner_join.Spatial}
\title{Dplyr verbs for Spatial}
\usage{
\method{mutate}{Spatial}(.data, ...)

\method{mutate_}{Spatial}(.data, ..., .dots)

\method{summarise_}{Spatial}(.data, ...)

\method{summarise}{Spatial}(.data, ...)

\method{group_by_}{Spatial}(.data, ...)

\method{group_by}{Spatial}(.data, ...)

\method{filter_}{Spatial}(.data, ..., .dots)

\method{filter}{Spatial}(.data, ...)

\method{arrange_}{Spatial}(.data, ...)

\method{arrange}{Spatial}(.data, ...)

\method{slice_}{Spatial}(.data, ...)

\method{slice}{Spatial}(.data, ...)

\method{select_}{Spatial}(.data, ...)

\method{select}{Spatial}(.data, ...)

\method{rename_}{Spatial}(.data, ...)

\method{rename}{Spatial}(.data, ...)

\method{distinct_}{Spatial}(.data, ..., .keep_all = FALSE)

\method{distinct}{Spatial}(.data, ..., .keep_all = FALSE)

\method{left_join}{Spatial}(x, y, by = NULL, copy = FALSE, ...)

\method{inner_join}{Spatial}(x, y, by = NULL, copy = FALSE, ...)
}
\arguments{
\item{.data}{A tbl.}

\item{...}{Name-value pairs of expressions. See \code{\link[dplyr]{mutate_}}}

\item{.dots}{Used to work around non-standard evaluation.}

\item{.keep_all}{argument for \code{\link[dplyr]{distinct}}, we have to set it to TRUE}

\item{x}{tbls to join}

\item{y}{tbl to join}

\item{by}{a character vector of variables to join by.  If \code{NULL}, the
default, \code{*_join()} will do a natural join, using all variables with
common names across the two tables. A message lists the variables so
that you can check they're right (to suppress the message, simply
explicitly list the variables that you want to join).

To join by different variables on x and y use a named vector.
For example, \code{by = c("a" = "b")} will match \code{x.a} to
\code{y.b}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}
}
\description{
Direct application of the dplyr verbs to Spatial objects. There is no need for a conversion from and to Spatial with this approach. Not all verbs are supported, see Details.
}
\details{
mutate, transmute, filter, arrange, slice, select, rename, distinct all work with attributes on the "data" slot and leave the geometry unchanged.

summarise collapses to a grouped geometries by listing all subgeometries together, it does not perform any topological union or merge, and it takes no account of the calculations done on attributes. 
This is a brutal collapse of all the data, and is identical to what is seen with spplot(x, "group"). The behaviour of geometric collapse like this
is touch and go anyway, see the examples for a what `rgeos::gUnion` does.

summarise for points and multipoints, ... todo single Multipoint for multiple points
}
\note{
Beware that attributes stored on Spatial objects *are not* linked to the geometry. Attributes are often used to 
store the area or perimeter length or centroid values but these may be completely unmatched to the underlying geometries.
}
\section{Warning}{

`distinct` uses behaviour identical to `duplicated`, by coercing all the relevant values to text and determining uniqueness
from those. `dplyr::distinct` uses a different internal method that will give different results for some cases of numeric data.
}

\examples{
library(sp)
library(maptools)
data(wrld_simpl)
library(spdplyr) 
library(raster)  
wrld_simpl \%>\% mutate(NAME = "allthesame", REGION = row_number())
wrld_simpl \%>\% transmute(alpha = paste0(FIPS, NAME))
wrld_simpl \%>\% filter(NAME \%in\% c("New Zealand", "Australia", "Fiji"))
\dontrun{
wrld_simpl \%>\% arrange(LON)
wrld_simpl \%>\% slice(c(9, 100))
wrld_simpl \%>\% dplyr::select(UN, FIPS)
wrld_simpl \%>\% rename(`TM_WORLD_BORDERS_SIMPL0.2NAME` = NAME)
wrld_simpl \%>\% distinct(REGION, .keep_all = TRUE) \%>\% 
   arrange(REGION)  ## first alphabetically in REGION
wrld_simpl \%>\% arrange(REGION, desc(NAME)) \%>\% distinct(REGION, .keep_all = TRUE) ## last
}
## we don't need to use piping
slice(filter(mutate(wrld_simpl, likepiping = FALSE), abs(LON - 5) < 35 & LAT > 50), 4)


## works with Lines
#as(wrld_simpl, "SpatialLinesDataFrame") \%>\% 
 # mutate(perim = rgeos::gLength(wrld_simpl, byid = TRUE))

\dontrun{
## summarise/ze can be used after group_by, or without
wrld_simpl \%>\% filter(REGION == 150) \%>\% summarize(max(AREA)) 
wrld_simpl \%>\% group_by(REGION) \%>\% summarize(max(AREA)) \%>\% 
plot(col = rainbow(nlevels(factor(wrld_simpl$REGION)), alpha = 0.3))
}
## group_by and summarize

\dontrun{
g <- wrld_simpl  \%>\% group_by(REGION)  \%>\% 
 summarize(alon = mean(LON), mxlat = max(LAT), mxarea = max(AREA))
g \%>\% mutate(ar = factor(REGION)) \%>\% spplot("ar")
w <- wrld_simpl
w$ar <- factor(w$REGION)
spplot(w, "ar")
}
\dontrun{
# compare what rgeos gives
##spplot(rgeos::gUnionCascaded(w, id = w$ar))  ## good grief, is this compelling . . .
## this is hardly a clean dissolve
##plot(rgeos::gUnionCascaded(w, id = w$ar), col = rainbow(nlevels(factor(w$ar)), alpha = 0.5))
}
}
