% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts.R
\name{change_from_baseline}
\alias{change_from_baseline}
\alias{treatment_effect}
\title{Calculate the Change from Baseline or Treatment Effects from Estimated
Marginal Means}
\usage{
change_from_baseline(
  emmeans,
  time_observed_continuous = emmeans@roles$predictors[2],
  time_scheduled_baseline = 0,
  arm = emmeans@roles$predictors[1],
  subgroup = if (length(emmeans@roles$predictors) == 3) emmeans@roles$predictors[3],
  contrast_args = list(adjust = "none"),
  ...,
  as_tibble = FALSE,
  confint_args = list(level = 0.95)
)

treatment_effect(
  emmeans,
  time_observed_continuous = emmeans@roles$predictors[2],
  time_scheduled_baseline,
  arm = emmeans@roles$predictors[1],
  subgroup = if (length(emmeans@roles$predictors) == 3) emmeans@roles$predictors[3],
  ref_value,
  subgroup_type = c("between", "within"),
  contrast_args = list(adjust = "none"),
  ...,
  as_tibble = FALSE,
  confint_args = list(level = 0.95)
)
}
\arguments{
\item{emmeans}{(\code{emmGrid})\cr an object of class
\code{\link[emmeans:emmGrid-class]{emmGrid}}, ideally obtained via
\code{\link[=ncs_emmeans]{ncs_emmeans()}}, which wraps \code{\link[emmeans:emmeans]{emmeans::emmeans()}}.}

\item{time_scheduled_baseline}{(\verb{scalar numeric})\cr the continuous time
point when baseline was \emph{scheduled} to occur. Defaults to 0.}

\item{arm, time_observed_continuous, subgroup}{(\code{string})\cr strings
identifying the study arm variable, \emph{observed} continuous time variable,
and (optionally) subgroup variable supplied to \code{\link[emmeans:emmeans]{emmeans::emmeans()}},
probably via \code{\link[=ncs_emmeans]{ncs_emmeans()}}). If \code{\link[=ncs_emmeans]{ncs_emmeans()}} was indeed used, these
strings \emph{should} be contained in the character vector
\code{emmeans@roles$predictors} (see the default arguments).}

\item{contrast_args, ...}{(named \code{list})\cr arguments to be passed to
\code{\link[emmeans:contrast]{emmeans::contrast()}}. Any arguments with the names \code{object} or \code{method}
will be overwritten. Arguments in \code{contrast_args} override identically
named arguments in \code{...}.}

\item{as_tibble}{(\code{flag})\cr \code{TRUE} or \code{FALSE} indicating whether or not the
results of \code{\link[emmeans:contrast]{emmeans::contrast()}} should be processed and returned as a
\link[dplyr:reexports]{tibble}.}

\item{confint_args}{(named \code{list})\cr arguments to be passed to
\code{\link[stats:confint]{stats::confint()}} when calculating confidence intervals. Ignored if
\code{as_tibble = FALSE}. If \code{NULL}, confidence intervals will not be
calculated. Defaults to \code{list(level = 0.95)}.}

\item{ref_value}{(\code{string})\cr the value in \code{arm} (if \code{subgroup = NULL} \emph{or}
if \code{subgroup_type = "within"}) or the value in \code{subgroup} (if \code{subgroup} is
not \code{NULL} \emph{and} \code{subgroup_type = "between"}) denoting the control group.}

\item{subgroup_type}{(\code{string})\cr either \code{"between"} or \code{"within"}, denoting
whether to calculate the treatment effect \emph{between} subgroups (examining
the differences between the subgroups within each study arm) and once
\emph{within} subgroups (examining the differences between the study arms within
each subgroup).}
}
\value{
When \code{as_tibble = FALSE}, the value returned by
\code{\link[emmeans:contrast]{emmeans::contrast()}}. If \code{as_tibble = TRUE}, a \link[dplyr:reexports]{tibble}:
\enumerate{
\item \{\emph{column name will be the value of the \code{arm} argument}\}: the study
arm.
\item \{\emph{column name will be the value of the \code{time_observed_continuous}
argument}\}: the \emph{observed} continuous time variable.
\item \{\emph{column name will be the value of the \code{subgroup} argument}\}: the
subgroup. \strong{Only present if \code{subgroup} is not \code{NULL}.}
\item \code{estimate}: estimate for change from baseline or treatment effect.
\item \code{SE}: standard error of \code{estimate}.
\item \code{df}: degrees of freedom for calculating the confidence interval for and
estimating the significance of \code{estimate}.
\item \code{lower.CL}: lower bound of confidence interval for \code{estimate}. \strong{Only
present if \code{confint_args} is not \code{NULL}.}
\item \code{upper.CL}: upper bound of confidence interval for \code{estimate}. \strong{Only
present if \code{confint_args} is not \code{NULL}.}
\item \code{t.ratio}: test statistic measuring the significance of \code{estimate}.
\item \code{p.value}: p-value for the significance of \code{estimate}.
}
}
\description{
Pass \code{\link[emmeans:emmeans]{emmeans::emmeans()}} objects (probably obtained via
\code{\link[=ncs_emmeans]{ncs_emmeans()}}) to \code{\link[emmeans:contrast]{emmeans::contrast()}} using specially constructed
contrast matrices so that change from baseline and treatment effects can be
calculated.
\itemize{
\item \code{change_from_baseline} calculate the change from baseline for each of the
different study arms/subgroups.
\item \code{treatment_effect()} calculate the treatment effect for each study arm
when there is no subgroup. When there is a subgroup, calculate the
treatment effect \emph{between} subgroups (examining the differences
\emph{between} the subgroups within each study arm) or \emph{within} subgroups
(examining the differences between the study arms \emph{within} each subgroup).
}
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Create a usable data set out of mmrm::fev_data
fev_mod <- mmrm::fev_data
fev_mod$VISITN <- fev_mod$VISITN * 10
fev_mod$time_cont <- fev_mod$VISITN + rnorm(nrow(fev_mod))
fev_mod$obs_visit_index <- round(fev_mod$time_cont)

fit <-
  ncs_mmrm_fit(
    data = fev_mod,
    type = "subgroup_full",
    response = FEV1,
    subject = USUBJID,
    cov_structs = c("ar1", "us"),
    time_observed_continuous = time_cont,
    df = 2,
    time_observed_index = obs_visit_index,
    time_scheduled_continuous = VISITN,
    arm = ARMCD,
    control_group = "PBO",
    subgroup = SEX,
    subgroup_comparator = "Male",
    covariates = ~ FEV1_BL + RACE
  )

marginal_means <-
  ncs_emmeans(
    fit = fit,
    observed_time = "time_cont",
    scheduled_time = "VISITN",
    arm = "ARMCD",
    subgroup = "SEX"
  )

change_from_baseline(
  emmeans = marginal_means,
  time_observed_continuous = "time_cont",
  time_scheduled_baseline = 10,
  arm = "ARMCD",
  subgroup = "SEX"
)

# Same thing as a tibble:
change_from_baseline(
  emmeans = marginal_means,
  time_observed_continuous = "time_cont",
  time_scheduled_baseline = 10,
  arm = "ARMCD",
  subgroup = "SEX",
  as_tibble = TRUE
)

treatment_effect(
  emmeans = marginal_means,
  time_observed_continuous = "time_cont",
  time_scheduled_baseline = 10,
  arm = "ARMCD",
  subgroup = "SEX",
  ref_value = "Male",
  as_tibble = TRUE
)
\dontshow{\}) # examplesIf}
}
