% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdensity.R
\name{ddensity}
\alias{ddensity}
\alias{pdensity}
\alias{qdensity}
\alias{rdensity}
\title{Distribution methods for density objects}
\usage{
ddensity(x, d)

pdensity(q, d)

qdensity(p, d)

rdensity(n, d)
}
\arguments{
\item{x}{a vector}

\item{d}{a \code{density} object}

\item{q}{a vector}

\item{p}{a vector of probabilities}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number of required}
}
\description{
Density, distribution function, quantile function and random generation 
from a kernel density estimate (using linear approximation).
}
\examples{
x <- rnorm(100, mean=0:5)
d <- density(x)
r <- rdensity(10000, d)
plot(d)
lines(density(r), new=TRUE, col='blue', lty='dashed')
}
\references{
\url{http://stackoverflow.com/questions/32871602/r-generate-data-from-a-probability-density-distribution}
}
\seealso{
\code{\link[stats]{density}}

\code{\link[stats]{approxfun}}

\code{\link[ks]{rkde}}
}
\author{
\href{http://stackoverflow.com/users/295691/user295691}{user295691}, 
  Neal Fultz
}
