% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal_kernel_functions-class.R
\name{exponential_dispersal_kernel}
\alias{exponential_dispersal_kernel}
\title{Negative exponential dispersal kernel}
\usage{
exponential_dispersal_kernel(distance_decay = 0.5, normalize = FALSE)
}
\arguments{
\item{distance_decay}{(exponential dispersal parameter) controls the rate at which the population disperses with distance}

\item{normalize}{(exponential dispersal parameter) should the normalising constant be used - default is FALSE.}
}
\value{
An object of class \code{dispersal_function}
}
\description{
This function determines the proportion of redistribution based on distance.
}
\examples{

\dontrun{
dists <- seq(0, 100, 1)

exp_dispersal_fun <- exponential_dispersal_kernel(distance_decay = 50)

plot(dists, exp_dispersal_fun(dists), type = 'l')
}
}
