% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_transformation.R
\name{sample_bart_posterior_predictive}
\alias{sample_bart_posterior_predictive}
\title{Sample from the posterior predictive distribution for outcomes modeled by BART}
\usage{
sample_bart_posterior_predictive(
  model_object,
  X = NULL,
  leaf_basis = NULL,
  rfx_group_ids = NULL,
  rfx_basis = NULL,
  num_draws_per_sample = NULL
)
}
\arguments{
\item{model_object}{A fitted BART model object of class \code{bartmodel}.}

\item{X}{A matrix or data frame of covariates. Required if the BART model depends on covariates (e.g., contains a mean or variance forest).}

\item{leaf_basis}{A matrix of bases for mean forest models with regression defined in the leaves. Required for "leaf regression" models.}

\item{rfx_group_ids}{A vector of group IDs for random effects model. Required if the BART model includes random effects.}

\item{rfx_basis}{A matrix of bases for random effects model. Required if the BART model includes random effects.}

\item{num_draws_per_sample}{The number of posterior predictive samples to draw for each posterior sample. Defaults to a heuristic based on the number of samples in a BART model (i.e. if the BART model has >1000 draws, we use 1 draw from the likelihood per sample, otherwise we upsample to ensure intervals are based on at least 1000 posterior predictive draws).}
}
\value{
Array of posterior predictive samples with dimensions (num_observations, num_posterior_samples, num_draws_per_sample) if num_draws_per_sample > 1, otherwise (num_observations, num_posterior_samples).
}
\description{
Sample from the posterior predictive distribution for outcomes modeled by BART
}
\examples{
n <- 100
p <- 5
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
y <- 2 * X[,1] + rnorm(n)
bart_model <- bart(y_train = y, X_train = X)
ppd_samples <- sample_bart_posterior_predictive(
  model_object = bart_model, X = X
)
}
