% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialLinesNetwork.R
\name{weightfield}
\alias{weightfield}
\alias{weightfield<-}
\alias{weightfield,SpatialLinesNetwork-method}
\alias{weightfield,sfNetwork-method}
\alias{weightfield<-,SpatialLinesNetwork,ANY-method}
\alias{weightfield<-,sfNetwork,ANY-method}
\alias{weightfield<-,SpatialLinesNetwork,character-method}
\alias{weightfield<-,sfNetwork,character-method}
\title{Get or set weight field in SpatialLinesNetwork}
\usage{
weightfield(x)

weightfield(x, varname) <- value

weightfield(x, varname) <- value

\S4method{weightfield}{SpatialLinesNetwork}(x)

\S4method{weightfield}{sfNetwork}(x)

\S4method{weightfield}{SpatialLinesNetwork,ANY}(x) <- value

\S4method{weightfield}{sfNetwork,ANY}(x) <- value

\S4method{weightfield}{SpatialLinesNetwork,character}(x, varname) <- value

\S4method{weightfield}{sfNetwork,character}(x, varname) <- value
}
\arguments{
\item{x}{SpatialLinesNetwork to use}

\item{varname}{The name of the variable to set/use.}

\item{value}{Either the name of the variable to use as the weight field or
a dataframe or vector containing the weights to use if \code{varname} is
passed to the replacement function. If the dataframe contains multiple
columns, the column with the same name as \code{varname} is used,
otherwise the first column is used.}
}
\description{
Get or set value of weight field in SpatialLinesNetwork
}
\section{Details}{

These functions manipulate the value of weightfield in a
SpatialLinesNetwork. When changing the value of weightfield, the weights
of the graph network are updated with the values of the corresponding
variables.
}

\examples{
# with sp objects
data(routes_fast)
rnet <- overline(routes_fast, attrib = "length")
sln <- SpatialLinesNetwork(rnet)
weightfield(sln) <- "length"
weightfield(sln, "randomnum") <- sample(1:10, size = nrow(sln@sl), replace = TRUE)
data(routes_fast_sf)
rnet <- overline(routes_fast_sf, attrib = "length")
sln <- SpatialLinesNetwork(rnet)
weightfield(sln) <- "length"
sln@sl$randomnum <- sample(1:10, size = nrow(sln@sl), replace = TRUE)
weightfield(sln) <- "randomnum"
# todo: show the difference that it makes
}
