% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_extract_4.R
\name{stri_extract_all}
\alias{stri_extract_all}
\alias{stri_extract_first}
\alias{stri_extract_last}
\alias{stri_extract}
\alias{stri_extract_all_charclass}
\alias{stri_extract_first_charclass}
\alias{stri_extract_last_charclass}
\alias{stri_extract_all_coll}
\alias{stri_extract_first_coll}
\alias{stri_extract_last_coll}
\alias{stri_extract_all_regex}
\alias{stri_extract_first_regex}
\alias{stri_extract_last_regex}
\alias{stri_extract_all_fixed}
\alias{stri_extract_first_fixed}
\alias{stri_extract_last_fixed}
\title{Extract Pattern Occurrences}
\usage{
stri_extract_all(str, ..., regex, fixed, coll, charclass)

stri_extract_first(str, ..., regex, fixed, coll, charclass)

stri_extract_last(str, ..., regex, fixed, coll, charclass)

stri_extract(
  str,
  ...,
  regex,
  fixed,
  coll,
  charclass,
  mode = c("first", "all", "last")
)

stri_extract_all_charclass(
  str,
  pattern,
  merge = TRUE,
  simplify = FALSE,
  omit_no_match = FALSE
)

stri_extract_first_charclass(str, pattern)

stri_extract_last_charclass(str, pattern)

stri_extract_all_coll(
  str,
  pattern,
  simplify = FALSE,
  omit_no_match = FALSE,
  ...,
  opts_collator = NULL
)

stri_extract_first_coll(str, pattern, ..., opts_collator = NULL)

stri_extract_last_coll(str, pattern, ..., opts_collator = NULL)

stri_extract_all_regex(
  str,
  pattern,
  simplify = FALSE,
  omit_no_match = FALSE,
  ...,
  opts_regex = NULL
)

stri_extract_first_regex(str, pattern, ..., opts_regex = NULL)

stri_extract_last_regex(str, pattern, ..., opts_regex = NULL)

stri_extract_all_fixed(
  str,
  pattern,
  simplify = FALSE,
  omit_no_match = FALSE,
  ...,
  opts_fixed = NULL
)

stri_extract_first_fixed(str, pattern, ..., opts_fixed = NULL)

stri_extract_last_fixed(str, pattern, ..., opts_fixed = NULL)
}
\arguments{
\item{str}{character vector; strings to search in}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{opts_collator}, \code{opts_regex},
and so on}

\item{mode}{single string;
one of: \code{'first'} (the default), \code{'all'}, \code{'last'}}

\item{pattern, regex, fixed, coll, charclass}{character vector;
search patterns; for more details refer to \link{stringi-search}}

\item{merge}{single logical value; indicates whether consecutive pattern
matches will be merged into one string;
\code{stri_extract_all_charclass} only}

\item{simplify}{single logical value;
if \code{TRUE} or \code{NA}, then a character matrix is returned;
otherwise (the default), a list of character vectors is given, see Value;
\code{stri_extract_all_*} only}

\item{omit_no_match}{single logical value; if \code{FALSE},
then a missing value will indicate that there was no match;
\code{stri_extract_all_*} only}

\item{opts_collator, opts_fixed, opts_regex}{a named list to tune up
the search engine's settings; see \code{\link{stri_opts_collator}},
\code{\link{stri_opts_fixed}}, and \code{\link{stri_opts_regex}},
respectively; \code{NULL} for the defaults}
}
\value{
For \code{stri_extract_all*}, if \code{simplify=FALSE} (the default), then
a list of character vectors is returned. Each list element
represents the results of a different search scenario.
If a pattern is not found and \code{omit_no_match=FALSE},
then a character vector of length 1
with single \code{NA} value will be generated.

Otherwise, i.e., if \code{simplify} is not \code{FALSE},
then \code{\link{stri_list2matrix}} with \code{byrow=TRUE} argument
is called on the resulting object.
In such a case, the function yields a character matrix with an appropriate
number of rows (according to the length of \code{str}, \code{pattern}, etc.).
Note that \code{\link{stri_list2matrix}}'s \code{fill} argument is set
either to an empty string or \code{NA}, depending on
whether \code{simplify} is \code{TRUE} or \code{NA}, respectively.

\code{stri_extract_first*} and \code{stri_extract_last*}
return a character vector. A \code{NA} element indicates a no-match.

Note that \code{stri_extract_last_regex} searches from start to end,
but skips overlapping matches, see the example below.
}
\description{
These functions extract all substrings matching a given pattern.

\code{stri_extract_all_*} extracts all the matches.
\code{stri_extract_first_*} and \code{stri_extract_last_*}
yield the first or the last matches, respectively.
}
\details{
Vectorized over \code{str} and \code{pattern} (with recycling
of the elements in the shorter vector if necessary). This allows to,
for instance, search for one pattern in each given string,
search for each pattern in one given string,
and search for the i-th pattern within the i-th string.

Check out \code{\link{stri_match}} for the extraction of matches
to individual regex capture groups.

\code{stri_extract}, \code{stri_extract_all}, \code{stri_extract_first},
and \code{stri_extract_last} are convenience functions.
They merely call \code{stri_extract_*_*}, depending on the arguments used.
}
\examples{
stri_extract_all('XaaaaX', regex=c('\\\\p{Ll}', '\\\\p{Ll}+', '\\\\p{Ll}{2,3}', '\\\\p{Ll}{2,3}?'))
stri_extract_all('Bartolini', coll='i')
stri_extract_all('stringi is so good!', charclass='\\\\p{Zs}') # all white-spaces

stri_extract_all_charclass(c('AbcdeFgHijK', 'abc', 'ABC'), '\\\\p{Ll}')
stri_extract_all_charclass(c('AbcdeFgHijK', 'abc', 'ABC'), '\\\\p{Ll}', merge=FALSE)
stri_extract_first_charclass('AaBbCc', '\\\\p{Ll}')
stri_extract_last_charclass('AaBbCc', '\\\\p{Ll}')

\dontrun{
# emoji support available since ICU 57
stri_extract_all_charclass(stri_enc_fromutf32(32:55200), '\\\\p{EMOJI}')
}

stri_extract_all_coll(c('AaaaaaaA', 'AAAA'), 'a')
stri_extract_first_coll(c('Yy\u00FD', 'AAA'), 'y', strength=2, locale='sk_SK')
stri_extract_last_coll(c('Yy\u00FD', 'AAA'), 'y',  strength=1, locale='sk_SK')

stri_extract_all_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+', '\\\\p{Ll}{2,3}', '\\\\p{Ll}{2,3}?'))
stri_extract_first_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+', '\\\\p{Ll}{2,3}', '\\\\p{Ll}{2,3}?'))
stri_extract_last_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+', '\\\\p{Ll}{2,3}', '\\\\p{Ll}{2,3}?'))

stri_list2matrix(stri_extract_all_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+')))
stri_extract_all_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+'), simplify=TRUE)
stri_extract_all_regex('XaaaaX', c('\\\\p{Ll}', '\\\\p{Ll}+'), simplify=NA)

stri_extract_all_fixed('abaBAba', 'Aba', case_insensitive=TRUE)
stri_extract_all_fixed('abaBAba', 'Aba', case_insensitive=TRUE, overlap=TRUE)

# Searching for the last occurrence:
# Note the difference - regex searches left to right, with no overlaps.
stri_extract_last_fixed("agAGA", "aga", case_insensitive=TRUE)
stri_extract_last_regex("agAGA", "aga", case_insensitive=TRUE)

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other search_extract: 
\code{\link{about_search}},
\code{\link{stri_extract_all_boundaries}()},
\code{\link{stri_match_all}()}
}
\concept{search_extract}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
